/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1.client;

import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.datastore.v1.client.EndToEndChecksumHandler;
import java.io.IOException;
import java.io.InputStream;

class ChecksumEnforcingInputStream
extends InputStream {
    private final InputStream delegate;
    private final EndToEndChecksumHandler endToEndChecksumHandler;
    private final String expectedChecksum;

    ChecksumEnforcingInputStream(InputStream originalInputStream, HttpResponse response) {
        this(originalInputStream, EndToEndChecksumHandler.getChecksumHeader(response));
    }

    @VisibleForTesting
    ChecksumEnforcingInputStream(InputStream originalInputStream, String checksum) {
        this.delegate = originalInputStream;
        this.expectedChecksum = checksum;
        this.endToEndChecksumHandler = new EndToEndChecksumHandler();
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        throw new RuntimeException("mark(int) Not Supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        throw new RuntimeException("read() Not Supported");
    }

    @Override
    public int read(byte[] b) throws IOException {
        throw new RuntimeException("read(byte[]) Not Supported");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        int i = this.delegate.read(b, off, len);
        if (i > 0) {
            this.endToEndChecksumHandler.update(b, off, i);
        } else if (!this.expectedChecksum.equalsIgnoreCase(this.endToEndChecksumHandler.hash())) {
            throw new IOException("possible memory corruption on payload detected");
        }
        return i;
    }

    @Override
    public void reset() throws IOException {
        throw new RuntimeException("reset() Not Supported");
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (n > Integer.MAX_VALUE) {
            throw new IOException("can't skip more than Integer.MAX bytes");
        }
        int intSkip = (int)n;
        byte[] b = new byte[intSkip];
        return this.read(b, 0, intSkip);
    }
}

