/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.AbstractGChart;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Color;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Fill;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.GraphChart;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.LegendPosition;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.LinearGradientFill;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.LinearStripesFill;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.SolidFill;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.TitledChart;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Preconditions;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.FillType;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.SolidFillType;

public abstract class AbstractGraphChart
extends AbstractGChart
implements GraphChart,
TitledChart {
    private TitledChart.ChartTitle chartTitle;
    private Fill areaFill;
    private LegendPosition legendPosition;
    private LegendMargins legendMargins;

    AbstractGraphChart() {
    }

    public final void setTitle(String title) {
        Preconditions.checkNotNull(title, "Title cannot be null.");
        this.chartTitle = new TitledChart.ChartTitle(title);
    }

    public final void setTitle(String title, Color color, int fontSize) {
        Preconditions.checkArgument(fontSize > 0, "font size must be > 0: %s", fontSize);
        Preconditions.checkNotNull(title, "Title cannot be null.");
        Preconditions.checkNotNull(color, "Color cannot be null.");
        this.chartTitle = new TitledChart.ChartTitle(title, color, fontSize);
    }

    public final void setLegendPosition(LegendPosition legendPosition) {
        Preconditions.checkNotNull(legendPosition, "Legend position cannot be null.");
        this.legendPosition = legendPosition;
    }

    public void setLegendMargins(int legendWidth, int legendHeight) {
        this.legendMargins = new LegendMargins(legendWidth, legendHeight);
    }

    public final void setAreaFill(Fill fill) {
        this.areaFill = (Fill)fill.klone();
    }

    protected void prepareData() {
        super.prepareData();
        if (this.areaFill instanceof SolidFill) {
            SolidFill solid = (SolidFill)this.areaFill;
            this.parameterManager.addSolidFill(SolidFillType.CHART_AREA, solid.getColor());
        } else if (this.areaFill instanceof LinearGradientFill) {
            LinearGradientFill lg = (LinearGradientFill)this.areaFill;
            this.parameterManager.addLinearGradientFill(FillType.CHART_AREA, lg.getAngle(), lg.getColorsAndOffsets());
        } else if (this.areaFill instanceof LinearStripesFill) {
            LinearStripesFill ls = (LinearStripesFill)this.areaFill;
            this.parameterManager.addLinearStripeFill(FillType.CHART_AREA, ls.getAngle(), ls.getColorsAndWidths());
        }
        if (this.chartTitle != null) {
            this.parameterManager.setChartTitleParameter(this.chartTitle.getTitle());
        }
        if (this.chartTitle != null && this.chartTitle.getColor() != null) {
            this.parameterManager.setChartTitleColorAndSizeParameter(this.chartTitle.getColor(), this.chartTitle.getFontSize());
        }
        if (this.legendPosition != null) {
            this.parameterManager.setLegendPositionParameter(this.legendPosition);
        }
        if (this.legendMargins != null) {
            this.parameterManager.setLegendMargins(this.legendMargins.width, this.legendMargins.height);
        }
    }

    private static class LegendMargins {
        private final int height;
        private final int width;

        private LegendMargins(int height, int width) {
            this.height = height;
            this.width = width;
        }
    }
}

