/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.AbstractMarkableChart;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Color;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.LineStyle;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.MarkedPoints;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Marker;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Plot;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.PlotImpl;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Priority;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.ImmutableList;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.FillAreaType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractLineChart
extends AbstractMarkableChart {
    private final ImmutableList<Plot> lines;

    AbstractLineChart(ImmutableList<? extends Plot> lines) {
        this.lines = Lists.copyOf(lines);
    }

    @Override
    protected void prepareData() {
        super.prepareData();
        List<Color> colors = Lists.newLinkedList();
        List<LineStyle> lStyles = Lists.newLinkedList();
        List<Priority> priorities = Lists.newLinkedList();
        boolean hasLegend = false;
        boolean hasColor = false;
        boolean hasLineStyle = false;
        boolean hasPriorities = false;
        for (Plot p : this.lines) {
            PlotImpl plot = (PlotImpl)p;
            hasLegend |= plot.getLegend() != null;
            hasColor |= plot.getColor() != null;
            hasLineStyle |= plot.getLineStyle() != null;
            hasPriorities |= plot.getPriority() != null;
        }
        int lineCount = 0;
        for (Plot p : this.lines) {
            PlotImpl line = (PlotImpl)p;
            if (hasLegend) {
                this.parameterManager.addLegend(line.getLegend() != null ? line.getLegend() : " ");
            }
            if (hasColor) {
                this.parameterManager.addColor(line.getColor() != null ? line.getColor() : Color.BLACK);
                colors.add(line.getColor() != null ? line.getColor() : Color.BLACK);
            }
            ImmutableList<Marker> markers = line.getMarkers();
            for (Marker m : markers) {
                this.parameterManager.addMarkers(m, lineCount);
            }
            ImmutableList<MarkedPoints> markedPointsList = line.getMarkedPointsList();
            for (MarkedPoints mp : markedPointsList) {
                this.parameterManager.addMarker(mp.getMarker(), lineCount, mp.getStartIndex(), mp.getEndIndex(), mp.getN());
            }
            if (line.getFillAreaColor() != null) {
                this.parameterManager.addFillAreaMarker(FillAreaType.FULL, line.getFillAreaColor(), lineCount, 0);
            }
            if (hasLineStyle) {
                this.parameterManager.addLineChartLineStyle(line.getLineStyle() != null ? line.getLineStyle() : LineStyle.newLineStyle(1, 1, 0));
                lStyles.add(line.getLineStyle() != null ? line.getLineStyle() : LineStyle.newLineStyle(1, 1, 0));
            }
            if (hasPriorities) {
                priorities.add(line.getPriority() != null ? line.getPriority() : Priority.NORMAL);
            }
            ++lineCount;
        }
        if (!priorities.isEmpty()) {
            this.setPriorities(priorities, colors, lStyles);
        }
    }

    protected final ImmutableList<Plot> getLines() {
        return Lists.copyOf(this.lines);
    }

    private void setPriorities(List<Priority> priorities, List<? extends Color> colors, List<? extends LineStyle> lineStyles) {
        for (int i = 0; i < priorities.size(); ++i) {
            Color color = colors.isEmpty() ? Color.BLACK : colors.get(i);
            int size = lineStyles.isEmpty() ? 1 : lineStyles.get(i).getLineThickness();
            this.parameterManager.addLineStyleMarker(color, i, 0, size, priorities.get(i));
        }
    }
}

