/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.AbstractAxisChart;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Color;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Preconditions;
import java.util.List;

public abstract class AbstractMarkableChart
extends AbstractAxisChart {
    private final List<VerticalRangeMarker> verticalRangeMarkers = Lists.newLinkedList();
    private final List<HorizontalRangeMarker> horizontalRangeMarkers = Lists.newLinkedList();

    AbstractMarkableChart() {
    }

    public final void addVerticalRangeMarker(double startPoint, double endPoint, Color color) {
        this.checkRangeArgs(startPoint, endPoint);
        Preconditions.checkNotNull(color, "Color cannot be null.");
        this.verticalRangeMarkers.add(new VerticalRangeMarker(color, startPoint, endPoint));
    }

    final void addRadialAxisRangeMarker(double startPoint, double endPoint, Color color) {
        this.checkRangeArgs(startPoint, endPoint);
        Preconditions.checkNotNull(color, "Color cannot be null.");
        this.verticalRangeMarkers.add(new VerticalRangeMarker(color, startPoint * 8.0, endPoint * 8.0));
    }

    public final void addHorizontalRangeMarker(double startPoint, double endPoint, Color color) {
        this.checkRangeArgs(startPoint, endPoint);
        Preconditions.checkNotNull(color, "Color cannot be null.");
        this.horizontalRangeMarkers.add(new HorizontalRangeMarker(color, startPoint, endPoint));
    }

    private void checkRangeArgs(double startPoint, double endPoint) {
        Preconditions.checkArgument(startPoint >= 0.0 && startPoint <= 100.0, "must be between 0 and 100 : %s", startPoint);
        Preconditions.checkArgument(endPoint >= 0.0 && endPoint <= 100.0, "must be between 0 and 100 : %s", endPoint);
        Preconditions.checkArgument(startPoint < endPoint, "start point must be < end point : %s %s", startPoint, endPoint);
    }

    protected void prepareData() {
        super.prepareData();
        for (HorizontalRangeMarker horizontalRangeMarker : this.horizontalRangeMarkers) {
            this.parameterManager.addHorizontalRangeMarker(((RangeMarker)horizontalRangeMarker).getColor(), ((RangeMarker)horizontalRangeMarker).getStartPoint() / 100.0, ((RangeMarker)horizontalRangeMarker).getEndPoint() / 100.0);
        }
        for (VerticalRangeMarker verticalRangeMarker : this.verticalRangeMarkers) {
            this.parameterManager.addVerticalRangeMarker(((RangeMarker)verticalRangeMarker).getColor(), ((RangeMarker)verticalRangeMarker).getStartPoint() / 100.0, ((RangeMarker)verticalRangeMarker).getEndPoint() / 100.0);
        }
    }

    private static final class HorizontalRangeMarker
    extends RangeMarker {
        private HorizontalRangeMarker(Color color, double startPoint, double endPoint) {
            super(color, startPoint, endPoint);
        }
    }

    private static final class VerticalRangeMarker
    extends RangeMarker {
        private VerticalRangeMarker(Color color, double startPoint, double endPoint) {
            super(color, startPoint, endPoint);
        }
    }

    private static class RangeMarker {
        private final Color color;
        private final double startPoint;
        private final double endPoint;

        private RangeMarker(Color color, double startPoint, double endPoint) {
            this.color = color;
            this.startPoint = startPoint;
            this.endPoint = endPoint;
        }

        private Color getColor() {
            return this.color;
        }

        private double getStartPoint() {
            return this.startPoint;
        }

        private double getEndPoint() {
            return this.endPoint;
        }
    }
}

