/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.AxisTextAlignment;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Color;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Kloneable;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AxisStyle
implements Kloneable<AxisStyle> {
    private final Color textColor;
    private final int fontSize;
    private final AxisTextAlignment alignment;
    private Boolean areTickMarksDrawn;
    private Integer tickMarkLength;
    private Color tickMarkColor;

    AxisStyle(Color textColor, int fontSize, AxisTextAlignment alignment) {
        this.textColor = textColor;
        this.fontSize = fontSize;
        this.alignment = alignment;
    }

    private AxisStyle(AxisStyle axisStyle) {
        this(axisStyle.textColor, axisStyle.fontSize, axisStyle.alignment);
        this.areTickMarksDrawn = axisStyle.areTickMarksDrawn;
        this.tickMarkColor = axisStyle.tickMarkColor;
        this.tickMarkLength = axisStyle.tickMarkLength;
    }

    @Override
    public AxisStyle klone() {
        return new AxisStyle(this);
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public AxisTextAlignment getAlignment() {
        return this.alignment;
    }

    public Boolean drawTickMarks() {
        return this.areTickMarksDrawn;
    }

    public void setDrawTickMarks(boolean drawTickMarks) {
        this.areTickMarksDrawn = drawTickMarks;
    }

    public Integer getTickMarkLength() {
        return this.tickMarkLength;
    }

    public void setTickMarkLength(int tickMarkLength) {
        this.setDrawTickMarks(true);
        this.tickMarkLength = tickMarkLength;
    }

    public Color getTickMarkColor() {
        return this.tickMarkColor;
    }

    public void setTickMarkColor(Color tickMarkColor) {
        if (tickMarkColor != null) {
            this.setDrawTickMarks(true);
            this.tickMarkColor = tickMarkColor;
        }
    }

    public static AxisStyle newAxisStyle(Color textColor, int fontSize, AxisTextAlignment alignment) {
        Preconditions.checkNotNull(textColor, "color must not be null");
        Preconditions.checkArgument(fontSize > 0, "fontsize must be > 0");
        Preconditions.checkNotNull(alignment, "alignment must not be null");
        return new AxisStyle(textColor, fontSize, alignment);
    }

    static AxisStyle correctAxisStyle(AxisStyle axisStyle) {
        AxisStyle as;
        if (axisStyle == null) {
            return null;
        }
        switch (axisStyle.alignment) {
            case RIGHT: {
                as = AxisStyle.newAxisStyle(axisStyle.textColor, axisStyle.fontSize, AxisTextAlignment.LEFT);
                break;
            }
            case LEFT: {
                as = AxisStyle.newAxisStyle(axisStyle.textColor, axisStyle.fontSize, AxisTextAlignment.RIGHT);
                break;
            }
            default: {
                as = axisStyle.klone();
            }
        }
        as.areTickMarksDrawn = axisStyle.areTickMarksDrawn;
        as.tickMarkColor = axisStyle.tickMarkColor;
        as.tickMarkLength = axisStyle.tickMarkLength;
        return as;
    }
}

