/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.AbstractAxisChart;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.BarChartPlot;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Color;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.MarkedPoints;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Marker;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Plot;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.PlotImpl;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.ImmutableList;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Preconditions;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ChartType;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.FillAreaType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarChart
extends AbstractAxisChart {
    public static final int AUTO_RESIZE = 0;
    private static final int DEFAULT_SPACE_WINTHIN_GROUPS_OF_BARS = 4;
    private static final int DEFAULT_SPACE_BETWEEN_GROUPS_OF_BARS = 8;
    private static final int DEFAULT_BAR_WIDTH = 23;
    private boolean dataStacked = false;
    private boolean horizontal = false;
    private int barWidth = 23;
    private int spaceBetweenGroupsOfBars = 8;
    private int spaceWithinGroupsOfBars = 4;
    private final ImmutableList<Plot> barChartPlots;

    BarChart(ImmutableList<? extends Plot> barChartPlots) {
        Preconditions.checkContentsNotNull(barChartPlots, "barChartPlots is null or contains a null plot");
        this.barChartPlots = Lists.copyOf(barChartPlots);
    }

    public final void setDataStacked(boolean dataStacked) {
        this.dataStacked = dataStacked;
    }

    public final void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
    }

    @Override
    protected void prepareData() {
        super.prepareData();
        boolean hasLegend = false;
        boolean hasColor = false;
        boolean hasZeroLine = false;
        for (Plot plot : this.barChartPlots) {
            PlotImpl series = (PlotImpl)plot;
            hasLegend |= series.getLegend() != null;
            hasColor |= series.getColor() != null || !series.getBarColors().isEmpty();
            hasZeroLine |= series.getZeroLine() != 0.0;
        }
        int lineCount = 0;
        for (Plot p : this.barChartPlots) {
            PlotImpl plot = (PlotImpl)p;
            this.parameterManager.addData(plot.getData());
            if (hasLegend) {
                this.parameterManager.addLegend(plot.getLegend() != null ? plot.getLegend() : " ");
            }
            if (hasColor) {
                if (plot.getBarColors().isEmpty()) {
                    this.parameterManager.addColor(plot.getColor() != null ? plot.getColor() : Color.BLACK);
                } else {
                    List colors = Lists.newArrayList();
                    List<Color> colorList = Lists.newLinkedList();
                    for (int i = 0; i < plot.getData().getSize(); ++i) {
                        colorList.add(plot.getColor() != null ? plot.getColor() : Color.BLACK);
                    }
                    for (BarChartPlot.BarColor bColor : plot.getBarColors()) {
                        if (bColor.getIndex() >= plot.getData().getSize()) continue;
                        colorList.set(bColor.getIndex(), bColor.getColor());
                    }
                    colors.add(Lists.copyOf(colorList));
                    this.parameterManager.addColors(Lists.copyOf(colors));
                }
            }
            if (hasZeroLine) {
                this.parameterManager.setBarChartZeroLineParameter(plot.getZeroLine() / 100.0);
            }
            if (plot.getDataLine() != null) {
                this.parameterManager.addLineStyleMarker(plot.getDataLine().getColor(), lineCount, 0, plot.getDataLine().getSize(), plot.getDataLine().getPriority());
            }
            for (Marker m : plot.getMarkers()) {
                this.parameterManager.addMarkers(m, lineCount);
            }
            for (MarkedPoints mp : plot.getMarkedPointsList()) {
                this.parameterManager.addMarker(mp.getMarker(), lineCount, mp.getStartIndex(), mp.getEndIndex(), mp.getN());
            }
            if (plot.getFillAreaColor() != null) {
                this.parameterManager.addFillAreaMarker(FillAreaType.FULL, plot.getFillAreaColor(), lineCount, 0);
            }
            ++lineCount;
        }
        this.parameterManager.setBarChartWidthAndSpacingParameter(this.barWidth, this.spaceWithinGroupsOfBars, this.spaceBetweenGroupsOfBars);
        if (this.horizontal && this.dataStacked) {
            this.parameterManager.setChartTypeParameter(ChartType.HORIZONTAL_STACKED_BAR_CHART);
        }
        if (!this.horizontal && this.dataStacked) {
            this.parameterManager.setChartTypeParameter(ChartType.VERTICAL_STACKED_BAR_CHART);
        }
        if (!this.horizontal && !this.dataStacked) {
            this.parameterManager.setChartTypeParameter(ChartType.VERTICAL_GROUPED_BAR_CHART);
        }
        if (this.horizontal && !this.dataStacked) {
            this.parameterManager.setChartTypeParameter(ChartType.HORIZONTAL_GROUPED_BAR_CHART);
        }
    }

    public final void setBarWidth(int barWidth) {
        Preconditions.checkArgument(barWidth > -1, "barWidth must be > 0");
        this.barWidth = barWidth;
    }

    public final void setSpaceBetweenGroupsOfBars(int spaceBetweenGroupsOfBars) {
        Preconditions.checkArgument(this.spaceWithinGroupsOfBars >= 0, "spaceWithinGroupsOfBars must be >= 0");
        this.spaceBetweenGroupsOfBars = spaceBetweenGroupsOfBars;
    }

    public final void setSpaceWithinGroupsOfBars(int spaceWithinGroupsOfBars) {
        Preconditions.checkArgument(spaceWithinGroupsOfBars >= 0, "spaceWithinGroupsOfBars must be >= 0");
        this.spaceWithinGroupsOfBars = spaceWithinGroupsOfBars;
    }
}

