/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.AbstractGChart;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Color;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Data;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.GeographicalArea;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.PoliticalBoundary;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.ImmutableList;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Preconditions;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ChartType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapChart
extends AbstractGChart {
    private static final int MAX_WIDTH = 440;
    private static final int MAX_HEIGHT = 220;
    private static final int MIN_WIDTH = 0;
    private static final int MIN_HEIGHT = 0;
    static final int DEFAULT_WIDTH = 440;
    static final int DEFAULT_HEIGHT = 220;
    private final List<PoliticalBoundary> pBoundaries = Lists.newLinkedList();
    private final List<Color> colorGradientList = Lists.newLinkedList();
    private final GeographicalArea geographicalArea;

    MapChart(GeographicalArea geographicalArea) {
        Preconditions.checkNotNull(geographicalArea, "geographicalArea cannot be null.");
        this.geographicalArea = geographicalArea;
    }

    @Override
    protected void prepareData() {
        super.prepareData();
        this.parameterManager.setGeographicalAreaParameter(this.geographicalArea);
        List<ImmutableList<Color>> colors = Lists.newArrayList();
        for (Color color : this.colorGradientList) {
            colors.add(Lists.of(color));
        }
        this.parameterManager.addColors(Lists.copyOf(colors));
        int cnt = 0;
        double[] countryColors = new double[this.pBoundaries.size()];
        for (PoliticalBoundary pb : this.pBoundaries) {
            this.parameterManager.addGeoCode(pb.getCode());
            countryColors[cnt++] = pb.getColor();
        }
        if (cnt > 0) {
            this.parameterManager.addData(Data.newData(countryColors));
        } else {
            this.parameterManager.addData(Data.INVALID);
        }
        this.parameterManager.setChartTypeParameter(ChartType.MAP_CHART);
    }

    public final void setColorGradient(Color defaultColor, Color ... colorGradient) {
        this.colorGradientList.clear();
        this.colorGradientList.add(defaultColor);
        this.colorGradientList.addAll(Lists.of(colorGradient));
    }

    public final void addPoliticalBoundary(PoliticalBoundary politicalBoundary) {
        this.pBoundaries.add(politicalBoundary);
    }

    public final void addPoliticalBoundaries(PoliticalBoundary ... politicalBoundaries) {
        this.pBoundaries.addAll(Lists.of(politicalBoundaries));
    }

    public final void addPoliticalBoundaries(List<? extends PoliticalBoundary> politicalBoundaries) {
        this.pBoundaries.addAll(politicalBoundaries);
    }

    @Override
    public final void setSize(int width, int height) {
        Preconditions.checkArgument(width > 0 && width <= 440, "width must be > 0 and <= 440: %s", width);
        Preconditions.checkArgument(height > 0 && height <= 220, "height must be > 0 and <= 440: %s", height);
        super.setSize(width, height);
    }
}

