/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.AbstractGraphChart;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Data;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Slice;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.ImmutableList;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ChartType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieChart
extends AbstractGraphChart {
    private boolean threeD = false;
    private final ImmutableList<Slice> slices;
    private double orientation = Double.NaN;

    public void setOrientation(double radians) {
        this.orientation = radians;
    }

    PieChart(ImmutableList<? extends Slice> slices) {
        this.slices = Lists.copyOf(slices);
    }

    public final boolean isThreeD() {
        return this.threeD;
    }

    public final void setThreeD(boolean threeD) {
        this.threeD = threeD;
    }

    @Override
    protected void prepareData() {
        super.prepareData();
        double[] d = new double[this.slices.size()];
        int i = 0;
        boolean hasLegend = false;
        double sum = 0.0;
        for (Slice slice : this.slices) {
            if (slice.getLegend() != null) {
                hasLegend |= true;
            }
            sum += (double)slice.getPercentage();
        }
        for (Slice slice : this.slices) {
            d[i++] = (double)slice.getPercentage() / sum * 100.0;
            this.parameterManager.addPieChartAndGoogleOMeterLegend(slice.getLabel() != null ? slice.getLabel() : "");
            if (hasLegend) {
                this.parameterManager.addLegend(slice.getLegend() != null ? slice.getLegend() : "");
            }
            if (slice.getColor() == null) continue;
            this.parameterManager.addColor(slice.getColor());
        }
        if (!Double.isNaN(this.orientation)) {
            this.parameterManager.addPieChartOrientation(this.orientation);
        }
        this.parameterManager.addData(Data.newData(d));
        this.parameterManager.setChartTypeParameter(this.threeD ? ChartType.THREE_D_PIE_CHART : ChartType.PIE_CHART);
    }
}

