/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.BarChartPlot;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Color;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Data;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Line;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Plot;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.PlotImpl;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.RadarPlot;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.ScatterPlotData;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.XYLine;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.ImmutableList;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Preconditions;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Plots {
    private Plots() {
        throw new AssertionError();
    }

    public static BarChartPlot newBarChartPlot(Data data) {
        Preconditions.checkNotNull(data, "data cannot be null.");
        return new PlotImpl(data);
    }

    public static BarChartPlot newBarChartPlot(Data data, Color color) {
        Preconditions.checkNotNull(data, "data cannot be null.");
        Preconditions.checkNotNull(color, "color cannot be null.");
        PlotImpl plot = new PlotImpl(data);
        plot.setColor(color);
        return plot;
    }

    public static BarChartPlot newBarChartPlot(Data data, Color color, String legend) {
        Preconditions.checkNotNull(data, "data cannot be null.");
        Preconditions.checkNotNull(color, "color cannot be null.");
        Preconditions.checkNotNull(legend, "legend cannot be null.");
        PlotImpl plot = new PlotImpl(data);
        plot.setColor(color);
        plot.setLegend(legend);
        return plot;
    }

    public static ScatterPlotData newScatterPlotData(Data xData, Data yData) {
        Preconditions.checkNotNull(xData, "x data cannot be null.");
        Preconditions.checkNotNull(yData, "y data cannot be null.");
        Preconditions.checkArgument(xData.getSize() == yData.getSize(), "x and y data do not have the same number of elements");
        return new PlotImpl(xData, yData);
    }

    public static ScatterPlotData newScatterPlotData(Data xData, Data yData, Data pointSizes) {
        Preconditions.checkNotNull(xData, "x data cannot be null.");
        Preconditions.checkNotNull(yData, "y data cannot be null.");
        Preconditions.checkNotNull(pointSizes, "pointSizes data cannot be null.");
        Preconditions.checkArgument(xData.getSize() == yData.getSize() && xData.getSize() == pointSizes.getSize(), "x, y, and pointSizes data do not have the same number of elements");
        PlotImpl plotImpl = new PlotImpl(xData, yData);
        plotImpl.setPointSizes(pointSizes);
        return plotImpl;
    }

    public static Line newLine(Data data) {
        Preconditions.checkNotNull(data, "data cannot be null.");
        return new PlotImpl(data);
    }

    public static Line newLine(Data data, Color color) {
        Preconditions.checkNotNull(data, "data cannot be null.");
        Preconditions.checkNotNull(color, "color cannot be null.");
        PlotImpl line = new PlotImpl(data);
        line.setColor(color);
        return line;
    }

    public static Line newLine(Data data, Color color, String legend) {
        Preconditions.checkNotNull(data, "data cannot be null.");
        Preconditions.checkNotNull(color, "color cannot be null.");
        Preconditions.checkNotNull(legend, "legend cannot be null.");
        PlotImpl line = new PlotImpl(data);
        line.setColor(color);
        line.setLegend(legend);
        return line;
    }

    public static XYLine newXYLine(Data xData, Data yData) {
        Preconditions.checkNotNull(xData, "x data cannot be null.");
        Preconditions.checkNotNull(yData, "y data cannot be null.");
        Preconditions.checkArgument(xData.getSize() == yData.getSize(), "x and y data do not have the same number of elements");
        return new PlotImpl(xData, yData);
    }

    public static XYLine newXYLine(Data xData, Data yData, Color color) {
        Preconditions.checkNotNull(xData, "x data cannot be null.");
        Preconditions.checkNotNull(yData, "y data cannot be null.");
        Preconditions.checkNotNull(color, "color cannot be null.");
        Preconditions.checkArgument(xData.getSize() == yData.getSize(), "x and y data do not have the same number of elements");
        PlotImpl xyLine = new PlotImpl(xData, yData);
        xyLine.setColor(color);
        return xyLine;
    }

    public static XYLine newXYLine(Data xData, Data yData, Color color, String legend) {
        Preconditions.checkNotNull(xData, "x data cannot be null.");
        Preconditions.checkNotNull(yData, "y data cannot be null.");
        Preconditions.checkNotNull(color, "color cannot be null.");
        Preconditions.checkNotNull(legend, "legend cannot be null.");
        Preconditions.checkArgument(xData.getSize() == yData.getSize(), "x and y data do not have the same number of elements");
        PlotImpl xyLine = new PlotImpl(xData, yData);
        xyLine.setColor(color);
        xyLine.setLegend(legend);
        return xyLine;
    }

    public static RadarPlot newRadarPlot(Data data) {
        Preconditions.checkNotNull(data, "data cannot be null.");
        return new PlotImpl(data);
    }

    public static RadarPlot newRadarPlot(Data data, Color color) {
        Preconditions.checkNotNull(data, "data cannot be null.");
        Preconditions.checkNotNull(color, "color cannot be null.");
        PlotImpl plot = new PlotImpl(data);
        plot.setColor(color);
        return plot;
    }

    public static RadarPlot newRadarPlot(Data data, Color color, String legend) {
        Preconditions.checkNotNull(data, "data cannot be null.");
        Preconditions.checkNotNull(color, "color cannot be null.");
        Preconditions.checkNotNull(legend, "legend cannot be null.");
        PlotImpl plot = new PlotImpl(data);
        plot.setColor(color);
        plot.setLegend(legend);
        return plot;
    }

    public static Plot newPlot(Data data) {
        Preconditions.checkNotNull(data, "data cannot be null.");
        return new PlotImpl(data);
    }

    public static Plot newPlot(Data data, Color color) {
        Preconditions.checkNotNull(data, "data cannot be null.");
        Preconditions.checkNotNull(color, "color cannot be null.");
        PlotImpl plotImpl = new PlotImpl(data);
        plotImpl.setColor(color);
        return plotImpl;
    }

    public static Plot newPlot(Data data, Color color, String legend) {
        Preconditions.checkNotNull(data, "data cannot be null.");
        Preconditions.checkNotNull(color, "color cannot be null.");
        Preconditions.checkNotNull(legend, "legend cannot be null.");
        PlotImpl plotImpl = new PlotImpl(data);
        plotImpl.setColor(color);
        plotImpl.setLegend(legend);
        return plotImpl;
    }

    static ImmutableList<Plot> copyOf(List<? extends Plot> plots) {
        List plotList = Lists.newLinkedList();
        for (Plot plot : plots) {
            plotList.add(plot.klone());
        }
        return Lists.copyOf(plotList);
    }

    static ImmutableList<Plot> copyOf(Plot ... plots) {
        return Plots.copyOf(Lists.of(plots));
    }
}

