/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.ImmutableList;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.Parameter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AxisLabelPositionsParameter
implements Parameter {
    private static final String URL_PARAMETER_KEY = "chxp";
    private final List<AxisLabelPositions> labelPositions = Lists.newLinkedList();

    AxisLabelPositionsParameter() {
    }

    void addLabelPosition(int index, ImmutableList<? extends Number> positions) {
        this.labelPositions.add(new AxisLabelPositions(index, positions));
    }

    @Override
    public String toURLParameterString() {
        StringBuilder sb = new StringBuilder("chxp=");
        int cnt = 0;
        for (AxisLabelPositions positions : this.labelPositions) {
            sb.append(cnt++ > 0 ? "|" : "").append(positions);
        }
        return !this.labelPositions.isEmpty() ? sb.toString() : "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AxisLabelPositions {
        private final int index;
        private final ImmutableList<Number> positions;

        private AxisLabelPositions(int index, ImmutableList<? extends Number> positions) {
            this.index = index;
            this.positions = Lists.copyOf(positions);
        }

        public String toString() {
            if (this.positions.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder(this.index + ",");
            int cnt = 0;
            for (Number n : this.positions) {
                sb.append(cnt++ > 0 ? "," : "").append(n);
            }
            return sb.toString();
        }
    }
}

