/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.ImmutableList;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.Parameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ParameterUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AxisLabelsParameter
implements Parameter {
    private static final String URL_PARAMETER_KEY = "chxl";
    private final List<AxisLabels> axisLabels = Lists.newLinkedList();

    AxisLabelsParameter() {
    }

    void addAxisLabels(int index, ImmutableList<? extends String> labels) {
        this.axisLabels.add(new AxisLabels(index, labels));
    }

    @Override
    public String toURLParameterString() {
        StringBuilder sb = new StringBuilder("chxl=");
        int cnt = 0;
        for (AxisLabels aLabels : this.axisLabels) {
            sb.append(cnt++ > 0 ? "|" : "").append(aLabels);
        }
        return !this.axisLabels.isEmpty() ? sb.toString() : "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AxisLabels {
        private final int index;
        private final ImmutableList<String> labels;

        private AxisLabels(int index, ImmutableList<? extends String> labels) {
            this.index = index;
            this.labels = Lists.copyOf(labels);
        }

        public String toString() {
            if (this.labels.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder(this.index + ":|");
            int cnt = 0;
            for (String label : this.labels) {
                String l = ParameterUtil.utf8Encode(label);
                sb.append(cnt++ > 0 ? "|" : "").append(l);
            }
            return sb.toString();
        }
    }
}

