/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.Parameter;
import java.util.List;

final class AxisRangesParameter
implements Parameter {
    private static final String URL_PARAMETER_KEY = "chxr";
    private final List<AxisRange> axisRanges = Lists.newLinkedList();

    AxisRangesParameter() {
    }

    void addAxisRange(int index, double startOfRange, double endOfRange, double interval) {
        this.axisRanges.add(new AxisRange(index, startOfRange, endOfRange, interval));
    }

    public String toURLParameterString() {
        StringBuilder sb = new StringBuilder("chxr=");
        int cnt = 0;
        for (AxisRange ar : this.axisRanges) {
            sb.append(cnt++ > 0 ? "|" : "").append(ar);
        }
        return !this.axisRanges.isEmpty() ? sb.toString() : "";
    }

    private static class AxisRange {
        private final int index;
        private final double startOfRange;
        private final double endOfRange;
        private final double interval;

        private AxisRange(int index, double startOfRange, double endOfRange, double interval) {
            this.index = index;
            this.startOfRange = startOfRange;
            this.endOfRange = endOfRange;
            this.interval = interval;
        }

        public String toString() {
            return this.index + "," + this.startOfRange + "," + this.endOfRange + (Double.isNaN(this.interval) ? "" : "," + this.interval);
        }
    }
}

