/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.AxisStyle;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.Parameter;
import java.util.List;

final class AxisStylesParameter
implements Parameter {
    private static final String URL_PARAMETER_KEY = "chxs";
    private final List<PrivateAxisStyles> axisStyles = Lists.newLinkedList();

    AxisStylesParameter() {
    }

    void addAxisStyle(int index, AxisStyle axisStyle) {
        this.axisStyles.add(new PrivateAxisStyles(index, axisStyle));
    }

    public String toURLParameterString() {
        StringBuilder sb = new StringBuilder("chxs=");
        int cnt = 0;
        for (PrivateAxisStyles styles : this.axisStyles) {
            sb.append(cnt++ > 0 ? "|" : "").append(styles);
        }
        return !this.axisStyles.isEmpty() ? sb.toString() : "";
    }

    private static final class PrivateAxisStyles {
        private static final String DRAW_TICK_MARKS = "t";
        private static final String DRAW_AXIS_LINE = "l";
        private final int index;
        private final AxisStyle axisStyle;

        private PrivateAxisStyles(int index, AxisStyle axisStyle) {
            this.index = index;
            this.axisStyle = axisStyle;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.index + "," + this.axisStyle.getTextColor() + "," + this.axisStyle.getFontSize() + "," + (Object)((Object)this.axisStyle.getAlignment()));
            sb.append(this.getDrawingControlString(this.axisStyle) != null ? "," + this.getDrawingControlString(this.axisStyle) : "");
            sb.append(this.axisStyle.getTickMarkColor() != null ? "," + this.axisStyle.getTickMarkColor() : "");
            return sb.toString();
        }

        private String getDrawingControlString(AxisStyle axisStyle) {
            StringBuilder sb = new StringBuilder();
            if (axisStyle.drawTickMarks() != null) {
                sb.append(axisStyle.drawTickMarks() != false ? "lt" : DRAW_AXIS_LINE);
            }
            return sb.length() > 0 ? sb.toString() : null;
        }
    }
}

