/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Color;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.ImmutableList;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ColorAndOffset;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ColorAndWidth;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.FillType;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.Parameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.SolidFillType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChartFillsParameter
implements Parameter {
    private static final String URL_PARAMETER_KEY = "chf";
    private final List<Fill> fills = Lists.newLinkedList();

    ChartFillsParameter() {
    }

    void addSolidFill(SolidFillType solidFillType, Color color) {
        this.fills.add(new Solid(solidFillType, color));
    }

    void addLinearGradientFill(FillType fillType, int angle, ImmutableList<? extends ColorAndOffset> colorAndOffsets) {
        this.fills.add(new LinearGradient(fillType, angle, colorAndOffsets));
    }

    void addLinearStripeFill(FillType fillType, int angle, ImmutableList<? extends ColorAndWidth> colorAndWidths) {
        this.fills.add(new LinearStripes(fillType, angle, colorAndWidths));
    }

    @Override
    public String toURLParameterString() {
        StringBuilder sb = new StringBuilder("chf=");
        int cnt = 0;
        for (Fill f : this.fills) {
            sb.append(cnt++ > 0 ? "|" : "").append(f);
        }
        return !this.fills.isEmpty() ? sb.toString() : "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LinearStripes
    implements Fill {
        private final FillType fillType;
        private final int angle;
        private final ImmutableList<ColorAndWidth> colorAndWidths;

        private LinearStripes(FillType fillType, int angle, ImmutableList<? extends ColorAndWidth> colorAndWidths) {
            this.fillType = fillType;
            this.angle = angle;
            this.colorAndWidths = Lists.copyOf(colorAndWidths);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int cnt = 0;
            for (ColorAndWidth cw : this.colorAndWidths) {
                sb.append(cnt++ > 0 ? "," : "").append(cw);
            }
            return (Object)((Object)this.fillType) + ",ls," + this.angle + "," + sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LinearGradient
    implements Fill {
        private final FillType fillType;
        private final int angle;
        private final ImmutableList<ColorAndOffset> colorAndOffsets;

        private LinearGradient(FillType fillType, int angle, ImmutableList<? extends ColorAndOffset> colorAndOffsets) {
            this.fillType = fillType;
            this.angle = angle;
            this.colorAndOffsets = Lists.copyOf(colorAndOffsets);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int cnt = 0;
            for (ColorAndOffset co : this.colorAndOffsets) {
                sb.append(cnt++ > 0 ? "," : "").append(co);
            }
            return (Object)((Object)this.fillType) + ",lg," + this.angle + "," + sb.toString();
        }
    }

    private static final class Solid
    implements Fill {
        private final SolidFillType solidFillType;
        private final Color color;

        Solid(SolidFillType solidFillType, Color color) {
            this.solidFillType = solidFillType;
            this.color = color;
        }

        public String toString() {
            return (Object)((Object)this.solidFillType) + ",s," + this.color;
        }
    }

    private static interface Fill {
    }
}

