/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Color;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.ImmutableList;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.Parameter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ColorsParameter
implements Parameter {
    private static final String URL_PARAMETER_KEY = "chco";
    private final List<List<Color>> colors = Lists.newLinkedList();

    ColorsParameter() {
    }

    void addColors(ImmutableList<? extends ImmutableList<? extends Color>> colors) {
        for (ImmutableList<? extends Color> immutableList : colors) {
            List<? extends Color> l = Lists.newLinkedList();
            l.addAll(immutableList);
            this.colors.add(l);
        }
    }

    @Override
    public String toURLParameterString() {
        StringBuilder sb = new StringBuilder("chco=");
        int cnt = 0;
        for (List<Color> l : this.colors) {
            sb.append(cnt++ > 0 ? "," : "");
            int i = 0;
            for (Color color : l) {
                sb.append(i++ > 0 ? "|" : "").append(color);
            }
        }
        return !this.colors.isEmpty() ? sb.toString() : "";
    }
}

