/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Data;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.DataEncoding;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.Parameter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;

final class DataParameter
implements Parameter {
    private static final String URL_PARAMETER_KEY = "chd";
    private final DecimalFormat decimalFormatter = new DecimalFormat("##0.0", new DecimalFormatSymbols(Locale.US));
    private static final char[] EXTENDED_ENCODING_CHARS;
    private static final char[] SIMPLE_ENCODING_CHARS;
    private static final String[] EXTENDED_ENCODING;
    private static final String[] SIMPLE_ENCODING;
    private final List<Data> datas = Lists.newLinkedList();
    private DataEncoding dataEncoding = DataEncoding.EXTENDED;

    DataParameter() {
    }

    void addData(Data data) {
        this.datas.add(data);
    }

    DataEncoding getDataEncoding() {
        return this.dataEncoding;
    }

    void setDataEncoding(DataEncoding dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    private String extendedEncoding(double[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuilder encodedData = new StringBuilder();
        for (double datum : data) {
            int index = (int)(datum >= 0.0 && datum <= 100.0 ? Math.round(datum / 100.0 * (double)(EXTENDED_ENCODING.length - 1)) : -1L);
            encodedData.append(index < 0 || index > EXTENDED_ENCODING.length - 1 ? "__" : EXTENDED_ENCODING[index]);
        }
        return encodedData.toString();
    }

    private String simpleEncoding(double[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuilder encodedData = new StringBuilder();
        for (double datum : data) {
            int index = (int)(datum >= 0.0 && datum <= 100.0 ? Math.round(datum / 100.0 * (double)(SIMPLE_ENCODING.length - 1)) : -1L);
            encodedData.append(index < 0 || index > SIMPLE_ENCODING.length - 1 ? "_" : SIMPLE_ENCODING[index]);
        }
        return encodedData.toString();
    }

    private String textEncoding(double[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuilder encodedData = new StringBuilder();
        int count = 0;
        for (double datum : data) {
            encodedData.append(count++ > 0 ? "," : "").append(datum >= 0.0 && datum <= 100.0 ? this.decimalFormatter.format(datum) : "-1");
        }
        return encodedData.toString();
    }

    public String toURLParameterString() {
        StringBuilder sb = new StringBuilder("chd=" + (Object)((Object)this.dataEncoding));
        String seperator = this.dataEncoding.equals((Object)DataEncoding.TEXT) ? "|" : ",";
        int cnt = 0;
        for (Data data : this.datas) {
            String dataString = this.dataEncoding.equals((Object)DataEncoding.SIMPLE) ? this.simpleEncoding(data.getData()) : (this.dataEncoding.equals((Object)DataEncoding.TEXT) ? this.textEncoding(data.getData()) : this.extendedEncoding(data.getData()));
            sb.append(cnt++ > 0 ? seperator : "").append(dataString);
        }
        return sb.toString();
    }

    static {
        int i;
        EXTENDED_ENCODING_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '.'};
        SIMPLE_ENCODING_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        EXTENDED_ENCODING = new String[4096];
        SIMPLE_ENCODING = new String[62];
        int cnt = 0;
        for (i = 0; i < EXTENDED_ENCODING_CHARS.length; ++i) {
            for (int j = 0; j < EXTENDED_ENCODING_CHARS.length; ++j) {
                DataParameter.EXTENDED_ENCODING[cnt++] = EXTENDED_ENCODING_CHARS[i] + "" + EXTENDED_ENCODING_CHARS[j];
            }
        }
        cnt = 0;
        for (i = 0; i < SIMPLE_ENCODING_CHARS.length; ++i) {
            DataParameter.SIMPLE_ENCODING[cnt++] = SIMPLE_ENCODING_CHARS[i] + "";
        }
    }
}

