/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.AxisStyle;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Color;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Data;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.DataEncoding;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.GeographicalArea;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.LegendPosition;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.LineStyle;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Marker;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Priority;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.ImmutableList;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Maps;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.AxisLabelPositionsParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.AxisLabelsParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.AxisRangesParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.AxisStylesParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.AxisTypes;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.AxisTypesParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.BarChartWidthAndSpacingParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.BarChartZeroLinesParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ChartFillsParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ChartMarkersParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ChartSizeParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ChartTitleColorAndSizeParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ChartTitleParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ChartType;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ChartTypeParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ColorAndOffset;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ColorAndWidth;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.ColorsParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.DataLegendsParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.DataParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.FillAreaType;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.FillType;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.GeoCodesParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.GeographicalAreaParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.GridLineParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.LegendPositionParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.LineChartLineStylesParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.MarginsParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.Parameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.PieChartAndGoogleOMeterLegendParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.PieChartOrientationParameter;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.SolidFillType;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.TickMarkLengthParameter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParameterManager {
    private final Map<Class<? extends Parameter>, Parameter> parameterMap = Maps.newHashMap();
    private String url;

    public void init(String url) {
        this.url = url;
        this.parameterMap.clear();
    }

    public void addAxisLabelPosition(int index, ImmutableList<? extends Number> positions) {
        this.getParameter(AxisLabelPositionsParameter.class).addLabelPosition(index, positions);
    }

    public void addAxisLabels(int index, ImmutableList<? extends String> labels) {
        this.getParameter(AxisLabelsParameter.class).addAxisLabels(index, labels);
    }

    public void addAxisRange(int index, double startOfRange, double endOfRange, double interval) {
        this.getParameter(AxisRangesParameter.class).addAxisRange(index, startOfRange, endOfRange, interval);
    }

    public void addAxisStyle(int index, AxisStyle axisStyle) {
        this.getParameter(AxisStylesParameter.class).addAxisStyle(index, axisStyle);
    }

    public void addTickMarkLength(int index, int tickMarkLength) {
        this.getParameter(TickMarkLengthParameter.class).addTickMarkLength(index, tickMarkLength);
    }

    public void addAxisTypes(AxisTypes axisTypes) {
        this.getParameter(AxisTypesParameter.class).addAxisTypes(axisTypes);
    }

    public void setBarChartWidthAndSpacingParameter(int width, int spaceBetweenBarsInGroup, int spaceBetweenGroups) {
        this.parameterMap.put(BarChartWidthAndSpacingParameter.class, new BarChartWidthAndSpacingParameter(width, spaceBetweenBarsInGroup, spaceBetweenGroups));
    }

    public void setBarChartZeroLineParameter(double d) {
        this.getParameter(BarChartZeroLinesParameter.class).addZeroLine(d);
    }

    public void addLinearGradientFill(FillType fillType, int angle, ImmutableList<? extends ColorAndOffset> colorAndOffsets) {
        this.getParameter(ChartFillsParameter.class).addLinearGradientFill(fillType, angle, colorAndOffsets);
    }

    public void addLinearStripeFill(FillType fillType, int angle, ImmutableList<? extends ColorAndWidth> colorAndWidths) {
        this.getParameter(ChartFillsParameter.class).addLinearStripeFill(fillType, angle, colorAndWidths);
    }

    public void addSolidFill(SolidFillType solidFillType, Color color) {
        this.getParameter(ChartFillsParameter.class).addSolidFill(solidFillType, color);
    }

    public void addFillAreaMarker(FillAreaType fillAreaType, Color color, int startLineIndex, int endLineIndex) {
        this.getParameter(ChartMarkersParameter.class).addFillAreaMarker(fillAreaType, color, startLineIndex, endLineIndex);
    }

    public void addLineStyleMarker(Color color, int dataSetIndex, int dataPoint, int size, Priority priority) {
        this.getParameter(ChartMarkersParameter.class).addLineStyleMarker(color, dataSetIndex, dataPoint, size, priority);
    }

    public void addMarker(Marker marker, int dataSetIndex, int startIndex, int endIndex, int n) {
        this.getParameter(ChartMarkersParameter.class).addMarker(marker, dataSetIndex, startIndex, endIndex, n);
    }

    public void addMarkers(Marker marker, int dataSetIndex) {
        this.getParameter(ChartMarkersParameter.class).addMarkers(marker, dataSetIndex);
    }

    public void addFreeMarker(Marker marker, double xPos, double yPos) {
        this.getParameter(ChartMarkersParameter.class).addFreeMarker(marker, xPos, yPos);
    }

    public void addVerticalRangeMarker(Color color, double startPoint, double endPoint) {
        this.getParameter(ChartMarkersParameter.class).addVerticalRangeMarker(color, startPoint, endPoint);
    }

    public void addHorizontalRangeMarker(Color color, double startPoint, double endPoint) {
        this.getParameter(ChartMarkersParameter.class).addHorizontalRangeMarker(color, startPoint, endPoint);
    }

    public void setChartSizeParameter(int width, int height) {
        this.parameterMap.put(ChartSizeParameter.class, new ChartSizeParameter(width, height));
    }

    public void setChartTitleColorAndSizeParameter(Color color, int fontSize) {
        this.parameterMap.put(ChartTitleColorAndSizeParameter.class, new ChartTitleColorAndSizeParameter(color, fontSize));
    }

    public void setChartTitleParameter(String title) {
        this.parameterMap.put(ChartTitleParameter.class, new ChartTitleParameter(title));
    }

    public void setChartTypeParameter(ChartType chartType) {
        this.parameterMap.put(ChartTypeParameter.class, new ChartTypeParameter(chartType));
    }

    public void addColor(Color color) {
        List<ImmutableList<Color>> colors = Lists.newArrayList();
        colors.add(Lists.of(color));
        this.getParameter(ColorsParameter.class).addColors(Lists.copyOf(colors));
    }

    public void addColors(ImmutableList<? extends ImmutableList<? extends Color>> colors) {
        this.getParameter(ColorsParameter.class).addColors(colors);
    }

    public void addLegend(String legend) {
        this.getParameter(DataLegendsParameter.class).addLegends(Lists.of(legend));
    }

    public void addLegends(ImmutableList<? extends String> legends) {
        this.getParameter(DataLegendsParameter.class).addLegends(legends);
    }

    public void addData(Data data) {
        this.getParameter(DataParameter.class).addData(data);
    }

    public void setDataEncoding(DataEncoding dataEncoding) {
        this.getParameter(DataParameter.class).setDataEncoding(dataEncoding);
    }

    public void addGeoCode(String geoCode) {
        this.getParameter(GeoCodesParameter.class).addGeoCode(geoCode);
    }

    public void setGeographicalAreaParameter(GeographicalArea geographicalArea) {
        this.parameterMap.put(GeographicalAreaParameter.class, new GeographicalAreaParameter(geographicalArea));
    }

    public void setGridLineParameter(double xAxisStepSize, double yAxisStepSize, int lengthOfLineSegment, int lengthOfBlankSegment) {
        this.parameterMap.put(GridLineParameter.class, new GridLineParameter(xAxisStepSize, yAxisStepSize, lengthOfLineSegment, lengthOfBlankSegment));
    }

    public void setLegendPositionParameter(LegendPosition legendPosition) {
        this.parameterMap.put(LegendPositionParameter.class, new LegendPositionParameter(legendPosition));
    }

    public void addLineChartLineStyle(LineStyle lineStyle) {
        this.getParameter(LineChartLineStylesParameter.class).addLineStyle(lineStyle);
    }

    public void addPieChartAndGoogleOMeterLegend(String legend) {
        this.getParameter(PieChartAndGoogleOMeterLegendParameter.class).addLegend(legend);
    }

    public void setMargins(int bottomMargin, int leftMargin, int rightMargin, int topMargin) {
        this.getParameter(MarginsParameter.class).setMargins(bottomMargin, leftMargin, rightMargin, topMargin);
    }

    public void setLegendMargins(int width, int height) {
        this.getParameter(MarginsParameter.class).setLegendMargins(width, height);
    }

    public void addPieChartOrientation(double orientation) {
        this.parameterMap.put(PieChartOrientationParameter.class, new PieChartOrientationParameter(orientation));
    }

    public String toString() {
        Collection<Parameter> c = this.parameterMap.values();
        List<String> parameters = Lists.newLinkedList();
        for (Parameter p : c) {
            String paramString = p.toURLParameterString();
            if ("".equals(paramString)) continue;
            parameters.add(paramString);
        }
        Collections.sort(parameters, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.length() - s2.length();
            }
        });
        int cnt = 0;
        StringBuilder sb = new StringBuilder(this.url + "?");
        for (String p : parameters) {
            sb.append(cnt++ > 0 ? "&" : "").append(p);
        }
        return sb.toString();
    }

    private <T extends Parameter> T getParameter(Class<T> clazz) throws ParameterInstantiationException {
        Parameter p = this.parameterMap.get(clazz);
        if (p == null) {
            try {
                p = (Parameter)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new ParameterInstantiationException("Internal error: Could not instatiate " + clazz.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new ParameterInstantiationException("Internal error: Could not instatiate " + clazz.getName(), e);
            }
            this.parameterMap.put(clazz, p);
        }
        return (T)p;
    }

    public static class ParameterInstantiationException
    extends RuntimeException {
        private static final long serialVersionUID = -7837316818196725716L;

        private ParameterInstantiationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

