/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters;

import com.google.appengine.labs.repackaged.com.googlecode.charts4j.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.parameters.Parameter;
import java.util.List;

public class TickMarkLengthParameter
implements Parameter {
    private static final String URL_PARAMETER_KEY = "chxtc";
    private final List<AxisTickMarkLength> tickMarkLengths = Lists.newLinkedList();

    public void addTickMarkLength(int index, int tickMarkLength) {
        this.tickMarkLengths.add(new AxisTickMarkLength(index, tickMarkLength));
    }

    public String toURLParameterString() {
        StringBuilder sb = new StringBuilder("chxtc=");
        int cnt = 0;
        for (AxisTickMarkLength tml : this.tickMarkLengths) {
            sb.append(cnt++ > 0 ? "|" : "").append(tml);
        }
        return !this.tickMarkLengths.isEmpty() ? sb.toString() : "";
    }

    private static final class AxisTickMarkLength {
        private final int index;
        private final int tickMarkLength;

        public AxisTickMarkLength(int index, int tickMarkLength) {
            this.index = index;
            this.tickMarkLength = tickMarkLength;
        }

        public String toString() {
            return this.index + "," + this.tickMarkLength;
        }
    }
}

