/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.labs.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.tools.appstats.RpcCostCalculator;
import com.google.appengine.tools.appstats.RpcOperationCostManager;
import com.google.appengine.tools.appstats.StatsProtos;
import com.google.apphosting.api.DatastorePb;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class DatastoreRpcCostCalculator
implements RpcCostCalculator {
    private static final String PKG = "datastore_v3";
    private final Map<String, RpcCostCalculator> methodMap = new HashMap<String, RpcCostCalculator>();
    private final long readCostMicrodollars;
    private final long writeCostMicrodollars;
    private final long smallOpCostMicrodollars;

    DatastoreRpcCostCalculator(long readCostMicrodollars, long writeCostMicrodollars, long smallOpCostMicrodollars) {
        this.readCostMicrodollars = readCostMicrodollars;
        this.writeCostMicrodollars = writeCostMicrodollars;
        this.smallOpCostMicrodollars = smallOpCostMicrodollars;
        this.methodMap.put("Get", new GetCostCalculator());
        this.methodMap.put("Put", new PutCostCalculator());
        this.methodMap.put("Delete", new DeleteCostCalculator());
        this.methodMap.put("Commit", new CommitCostCalculator());
        this.methodMap.put("RunQuery", new RunQueryCostCalculator());
        this.methodMap.put("Next", new NextCostCalculator());
        this.methodMap.put("AllocateIds", new AllocateIdsCostCalculator());
    }

    @Override
    public RpcCostCalculator.RpcCost determineCost(String methodName, byte[] request, byte[] response) {
        RpcCostCalculator calculator = this.methodMap.get(methodName);
        if (calculator == null) {
            return FREE;
        }
        return calculator.determineCost(methodName, request, response);
    }

    static void register(Map<String, RpcCostCalculator> costCalculatorMap, RpcOperationCostManager opCostMgr) {
        costCalculatorMap.put(PKG, new DatastoreRpcCostCalculator(opCostMgr.costOf(StatsProtos.BilledOpProto.BilledOp.DATASTORE_READ), opCostMgr.costOf(StatsProtos.BilledOpProto.BilledOp.DATASTORE_WRITE), opCostMgr.costOf(StatsProtos.BilledOpProto.BilledOp.DATASTORE_SMALL)));
    }

    static RpcCostCalculator.RpcCost newRpcCost(long costMicrodollars, int numOps, StatsProtos.BilledOpProto.BilledOp billedOp) {
        return DatastoreRpcCostCalculator.newRpcCost(costMicrodollars, ImmutableMap.of(billedOp, numOps));
    }

    static RpcCostCalculator.RpcCost newRpcCost(long costMicrodollars, Map<StatsProtos.BilledOpProto.BilledOp, Integer> billedOpMap) {
        ArrayList<StatsProtos.BilledOpProto> billedOpProtos = new ArrayList<StatsProtos.BilledOpProto>();
        for (Map.Entry<StatsProtos.BilledOpProto.BilledOp, Integer> entry : billedOpMap.entrySet()) {
            if (entry.getValue() <= 0) continue;
            billedOpProtos.add(StatsProtos.BilledOpProto.newBuilder().setNumOps(entry.getValue()).setOp(entry.getKey()).build());
        }
        return new RpcCostCalculator.RpcCost(costMicrodollars, billedOpProtos);
    }

    RpcCostCalculator.RpcCost billForReadOps(int reads) {
        return DatastoreRpcCostCalculator.newRpcCost(this.readCostMicrodollars * (long)reads, reads, StatsProtos.BilledOpProto.BilledOp.DATASTORE_READ);
    }

    RpcCostCalculator.RpcCost billForSmallOps(int smallOps) {
        return DatastoreRpcCostCalculator.newRpcCost(this.smallOpCostMicrodollars * (long)smallOps, smallOps, StatsProtos.BilledOpProto.BilledOp.DATASTORE_SMALL);
    }

    RpcCostCalculator.RpcCost billForWriteOps(int writeOps) {
        return DatastoreRpcCostCalculator.newRpcCost(this.writeCostMicrodollars * (long)writeOps, writeOps, StatsProtos.BilledOpProto.BilledOp.DATASTORE_WRITE);
    }

    private class AllocateIdsCostCalculator
    implements RpcCostCalculator {
        private final RpcCostCalculator.RpcCost cost;

        AllocateIdsCostCalculator() {
            this.cost = DatastoreRpcCostCalculator.this.billForSmallOps(1);
        }

        @Override
        public RpcCostCalculator.RpcCost determineCost(String methodName, byte[] request, byte[] response) {
            return this.cost;
        }
    }

    private class NextCostCalculator
    extends QueryCostCalculator {
        private NextCostCalculator() {
        }

        @Override
        int getBaselineReads() {
            return 0;
        }
    }

    private class RunQueryCostCalculator
    extends QueryCostCalculator {
        private RunQueryCostCalculator() {
        }

        @Override
        int getBaselineReads() {
            return 1;
        }
    }

    private abstract class QueryCostCalculator
    implements RpcCostCalculator {
        private QueryCostCalculator() {
        }

        @Override
        public RpcCostCalculator.RpcCost determineCost(String methodName, byte[] request, byte[] response) {
            DatastorePb.QueryResult proto = new DatastorePb.QueryResult();
            proto.parseFrom(response);
            int numResults = proto.resultSize() + proto.getSkippedResults();
            int baselineReads = this.getBaselineReads();
            long costMicrodollars = DatastoreRpcCostCalculator.this.readCostMicrodollars * (long)baselineReads;
            if (proto.isKeysOnly()) {
                return DatastoreRpcCostCalculator.newRpcCost(costMicrodollars += DatastoreRpcCostCalculator.this.smallOpCostMicrodollars * (long)numResults, ImmutableMap.of(StatsProtos.BilledOpProto.BilledOp.DATASTORE_READ, baselineReads, StatsProtos.BilledOpProto.BilledOp.DATASTORE_SMALL, numResults));
            }
            return DatastoreRpcCostCalculator.newRpcCost(costMicrodollars += DatastoreRpcCostCalculator.this.readCostMicrodollars * (long)numResults, numResults + baselineReads, StatsProtos.BilledOpProto.BilledOp.DATASTORE_READ);
        }

        abstract int getBaselineReads();
    }

    private class CommitCostCalculator
    implements RpcCostCalculator {
        private CommitCostCalculator() {
        }

        @Override
        public RpcCostCalculator.RpcCost determineCost(String methodName, byte[] request, byte[] response) {
            DatastorePb.CommitResponse proto = new DatastorePb.CommitResponse();
            proto.parseFrom(response);
            DatastorePb.Cost costProto = proto.getCost();
            int writes = costProto.getCommitCost().getRequestedEntityPuts() + costProto.getCommitCost().getRequestedEntityDeletes() + costProto.getIndexWrites();
            return DatastoreRpcCostCalculator.this.billForWriteOps(writes);
        }
    }

    private class DeleteCostCalculator
    implements RpcCostCalculator {
        private DeleteCostCalculator() {
        }

        @Override
        public RpcCostCalculator.RpcCost determineCost(String methodName, byte[] request, byte[] response) {
            DatastorePb.DeleteResponse proto = new DatastorePb.DeleteResponse();
            proto.parseFrom(response);
            int writes = proto.getCost().getEntityWrites() + proto.getCost().getIndexWrites();
            return DatastoreRpcCostCalculator.this.billForWriteOps(writes);
        }
    }

    private class PutCostCalculator
    implements RpcCostCalculator {
        private PutCostCalculator() {
        }

        @Override
        public RpcCostCalculator.RpcCost determineCost(String methodName, byte[] request, byte[] response) {
            DatastorePb.PutResponse proto = new DatastorePb.PutResponse();
            proto.parseFrom(response);
            int writes = proto.getCost().getEntityWrites() + proto.getCost().getIndexWrites();
            return DatastoreRpcCostCalculator.this.billForWriteOps(writes);
        }
    }

    private class GetCostCalculator
    implements RpcCostCalculator {
        private GetCostCalculator() {
        }

        @Override
        public RpcCostCalculator.RpcCost determineCost(String methodName, byte[] request, byte[] response) {
            DatastorePb.GetRequest proto = new DatastorePb.GetRequest();
            proto.parseFrom(request);
            return DatastoreRpcCostCalculator.this.billForReadOps(proto.keySize());
        }
    }
}

