/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.tools.appstats.ChannelRpcCostCalculator;
import com.google.appengine.tools.appstats.DatastoreRpcCostCalculator;
import com.google.appengine.tools.appstats.MailRpcCostCalculator;
import com.google.appengine.tools.appstats.PayloadRenderer;
import com.google.appengine.tools.appstats.RpcCostCalculator;
import com.google.appengine.tools.appstats.StaticRpcOperationCostManager;
import com.google.appengine.tools.appstats.StatsProtos;
import com.google.appengine.tools.appstats.XMPPRpcCostCalculator;
import com.google.apphosting.api.ApiStats;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

class RecordingData {
    private static final Map<String, RpcCostCalculator> COST_CALCULATOR_MAP;
    private StatsProtos.IndividualRpcStatsProto.Builder stats;
    private String packageName;
    private String methodName;
    private boolean calculateRpcCosts;
    private boolean wasSuccessful;
    private long durationMilliseconds;
    private Long apiMcyclesOrNull;
    private byte[] response;
    private Throwable exceptionOrError;
    private long overhead;
    private ApiStats apiStats;
    private boolean isProcessed;

    RecordingData(String packageName, String methodName, boolean calculateRpcCosts) {
        this.setPackageName(packageName);
        this.setMethodName(methodName);
        this.setCalculateRpcCosts(calculateRpcCosts);
    }

    ApiStats getApiStats() {
        return this.apiStats;
    }

    void setApiStats(ApiStats apiStats) {
        this.apiStats = apiStats;
    }

    StatsProtos.IndividualRpcStatsProto.Builder getStats() {
        return this.stats;
    }

    void setStats(StatsProtos.IndividualRpcStatsProto.Builder stats) {
        this.stats = stats;
    }

    String getPackageName() {
        return this.packageName;
    }

    void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    String getMethodName() {
        return this.methodName;
    }

    void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    void setCalculateRpcCosts(boolean calculateRpcCosts) {
        this.calculateRpcCosts = calculateRpcCosts;
    }

    boolean isWasSuccessful() {
        return this.wasSuccessful;
    }

    void setWasSuccessful(boolean wasSuccessful) {
        this.wasSuccessful = wasSuccessful;
    }

    long getDurationMilliseconds() {
        return this.durationMilliseconds;
    }

    void setDurationMilliseconds(long durationMilliseconds) {
        this.durationMilliseconds = durationMilliseconds;
    }

    Long getApiMcyclesOrNull() {
        return this.apiMcyclesOrNull;
    }

    void setApiMcyclesOrNull(Long apiMcyclesOrNull) {
        this.apiMcyclesOrNull = apiMcyclesOrNull;
    }

    byte[] getResponse() {
        return this.response;
    }

    void setResponse(byte[] response) {
        this.response = response;
    }

    Throwable getExceptionOrError() {
        return this.exceptionOrError;
    }

    void setExceptionOrError(Throwable exceptionOrError) {
        this.exceptionOrError = exceptionOrError;
    }

    long getOverhead() {
        return this.overhead;
    }

    void addOverhead(long overhead) {
        this.overhead += overhead;
    }

    boolean isProcessed() {
        return this.isProcessed;
    }

    void setProcessed() {
        this.isProcessed = true;
    }

    void storeResultData(PayloadRenderer payloadRenderer, byte[] request) {
        this.stats.setWasSuccessful(this.wasSuccessful);
        this.stats.setDurationMilliseconds(this.durationMilliseconds);
        if (this.apiMcyclesOrNull != null) {
            this.stats.setApiMcycles(this.apiMcyclesOrNull);
        }
        if (this.response != null) {
            this.stats.setResponseDataSummary(payloadRenderer.renderPayload(this.packageName, this.methodName, this.response, false));
            RpcCostCalculator rcc = COST_CALCULATOR_MAP.get(this.packageName);
            if (rcc != null && this.calculateRpcCosts) {
                RpcCostCalculator.RpcCost rpcCost = rcc.determineCost(this.methodName, request, this.response);
                this.stats.setCallCostMicrodollars(rpcCost.getCostMicrodollars());
                for (StatsProtos.BilledOpProto billedOpProto : rpcCost.getBilledOps()) {
                    this.stats.addBilledOps(billedOpProto);
                }
            }
        }
        if (this.exceptionOrError != null) {
            StringWriter stackTrace = new StringWriter();
            this.exceptionOrError.printStackTrace(new PrintWriter(stackTrace));
            this.stats.setResponseDataSummary(stackTrace.toString());
        }
    }

    static {
        StaticRpcOperationCostManager costMgr = new StaticRpcOperationCostManager();
        COST_CALCULATOR_MAP = new HashMap<String, RpcCostCalculator>();
        DatastoreRpcCostCalculator.register(COST_CALCULATOR_MAP, costMgr);
        MailRpcCostCalculator.register(COST_CALCULATOR_MAP, costMgr);
        ChannelRpcCostCalculator.register(COST_CALCULATOR_MAP, costMgr);
        XMPPRpcCostCalculator.register(COST_CALCULATOR_MAP, costMgr);
    }
}

