/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.labs.repackaged.com.google.common.base.Function;
import com.google.appengine.labs.repackaged.com.google.common.base.Joiner;
import com.google.appengine.labs.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.labs.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.tools.appstats.StatsProtos;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class StatsUtil {
    private static final double MCYCLES_PER_SECOND = 1200.0;
    private static final BigDecimal ONE_HUNDRED = new BigDecimal(100);
    private static final Comparator<List<Object>> BY_FIRST_ELEMENT = StatsUtil.makeComparator(0, 1, 2);
    private static final Comparator<List<Object>> BY_SECOND_ELEMENT = StatsUtil.makeComparator(1, 0, 2);
    private static final Comparator<Map.Entry<String, ? extends BaseStats>> BY_NUM_RPCS = new Comparator<Map.Entry<String, ? extends BaseStats>>(){

        @Override
        public int compare(Map.Entry<String, ? extends BaseStats> o1, Map.Entry<String, ? extends BaseStats> o2) {
            int c = -o1.getValue().numRpcs.compareTo(o2.getValue().numRpcs);
            if (c == 0) {
                c = o1.getKey().compareTo(o2.getKey());
            }
            return c;
        }
    };

    private StatsUtil() {
    }

    private static String extractKey(StatsProtos.RequestStatProto summary) {
        String result = summary.getHttpPath();
        if (!summary.getHttpMethod().equals("GET")) {
            result = summary.getHttpMethod() + " " + result;
        }
        return result;
    }

    static long megaCyclesToMilliseconds(long megaCycles) {
        return (long)((double)(1000L * megaCycles) / 1200.0);
    }

    private static Map<String, Object> toMap(Message proto) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Descriptors.FieldDescriptor field : proto.getDescriptorForType().getFields()) {
            Object value = proto.getField(field);
            if (value == null) continue;
            result.put(field.getName(), value);
            if (!(value instanceof List)) continue;
            result.put(field.getName() + "_list", value);
            result.put(field.getName() + "_size", ((List)value).size());
        }
        return result;
    }

    private static Map<String, Object> augmentProto(StatsProtos.RequestStatProto proto) {
        List<StatsProtos.IndividualRpcStatsProto> individualRpcs = proto.getIndividualStatsList();
        Map<String, Object> result = StatsUtil.toMap((Message)proto);
        result.put("api_milliseconds", StatsUtil.megaCyclesToMilliseconds(proto.getApiMcycles()));
        result.put("processor_milliseconds", StatsUtil.megaCyclesToMilliseconds(proto.getProcessorMcycles()));
        result.put("start_time_formatted", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(proto.getStartTimestampMilliseconds())));
        ArrayList<Map<String, Object>> sublist = new ArrayList<Map<String, Object>>();
        BilledOpsMap billedOpsMap = new BilledOpsMap();
        for (StatsProtos.IndividualRpcStatsProto stat : individualRpcs) {
            Map<String, Object> subMap = StatsUtil.toMap((Message)stat);
            subMap.put("api_milliseconds", StatsUtil.megaCyclesToMilliseconds(stat.getApiMcycles()));
            String billedOps = Joiner.on(", ").join(Iterables.transform(stat.getBilledOpsList(), new Function<StatsProtos.BilledOpProto, Object>(){

                @Override
                public Object apply(StatsProtos.BilledOpProto proto) {
                    return String.format("%s:%d", new Object[]{proto.getOp(), proto.getNumOps()});
                }
            }));
            subMap.put("billed_ops_str", billedOps);
            sublist.add(subMap);
        }
        result.put("individual_stats", sublist);
        result.put("individual_stats_list", sublist);
        long count = 0L;
        long costInMicrodollars = 0L;
        for (StatsProtos.AggregateRpcStatsProto stat : proto.getRpcStatsList()) {
            count += stat.getTotalAmountOfCalls();
            costInMicrodollars += stat.getTotalCostOfCallsMicrodollars();
            for (StatsProtos.BilledOpProto costOp : stat.getTotalBilledOpsList()) {
                Integer opTotal = (Integer)billedOpsMap.get((Object)costOp.getOp());
                if (opTotal == null) {
                    billedOpsMap.put(costOp.getOp(), 0);
                    opTotal = 0;
                }
                billedOpsMap.put(costOp.getOp(), opTotal + costOp.getNumOps());
            }
        }
        result.put("combined_rpc_count", count);
        result.put("combined_rpc_cost_microdollars", costInMicrodollars);
        result.put("combined_rpc_billed_ops", billedOpsMap);
        return result;
    }

    private static List<List<Object>> asTupleOrderedByNumRpcs(Map<String, ? extends BaseStats> elements, BigDecimal totalRpcCostsMicrodollars) {
        ArrayList<Map.Entry<String, ? extends BaseStats>> sorted = new ArrayList<Map.Entry<String, ? extends BaseStats>>(elements.entrySet());
        Collections.sort(sorted, BY_NUM_RPCS);
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(sorted.size());
        for (Map.Entry entry : sorted) {
            BaseStats baseStats = (BaseStats)entry.getValue();
            result.add(Arrays.asList(entry.getKey(), baseStats.numRpcs, baseStats.rpcCostMicrodollars, baseStats.billedOps, StatsUtil.asPercentageOf(baseStats.rpcCostMicrodollars, totalRpcCostsMicrodollars)));
        }
        return result;
    }

    static double asPercentageOf(long costMicrodollars, BigDecimal totalCostMicrodollars) {
        return totalCostMicrodollars.longValue() == 0L ? 0.0 : new BigDecimal(costMicrodollars).divide(totalCostMicrodollars, 3, RoundingMode.HALF_UP).multiply(ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    private static Comparator<List<Object>> makeComparator(final int ... fieldOrder) {
        return new Comparator<List<Object>>(){

            @Override
            public int compare(List<Object> o1, List<Object> o2) {
                int result = 0;
                for (int i : fieldOrder) {
                    Comparable c1 = (Comparable)o1.get(i);
                    Comparable c2 = (Comparable)o2.get(i);
                    int n = result = c1 instanceof Number ? -c1.compareTo(c2) : c1.compareTo(c2);
                    if (result == 0) continue;
                    return result;
                }
                return result;
            }
        };
    }

    static Map<String, Object> createSummaryStats(List<StatsProtos.RequestStatProto> records) {
        records = new ArrayList<StatsProtos.RequestStatProto>(records);
        Collections.sort(records, new Comparator<StatsProtos.RequestStatProto>(){

            @Override
            public int compare(StatsProtos.RequestStatProto o1, StatsProtos.RequestStatProto o2) {
                Long l1 = o1.getStartTimestampMilliseconds();
                Long l2 = o2.getStartTimestampMilliseconds();
                return -l1.compareTo(l2);
            }
        });
        ArrayList<Map<String, Object>> augmented = new ArrayList<Map<String, Object>>(records.size());
        for (StatsProtos.RequestStatProto proto : records) {
            augmented.add(StatsUtil.augmentProto(proto));
        }
        HashMap<String, PathStats> statsByPath = new HashMap<String, PathStats>();
        HashMap<String, RpcStats> statsByRpc = new HashMap<String, RpcStats>();
        BigDecimal totalCostMicrodollars = new BigDecimal(0);
        for (int i = 0; i < records.size(); ++i) {
            StatsProtos.RequestStatProto requestStat = records.get(i);
            String pathKey = StatsUtil.extractKey(requestStat);
            PathStats pathStats = (PathStats)statsByPath.get(pathKey);
            if (pathStats == null) {
                pathStats = new PathStats(pathKey);
                statsByPath.put(pathKey, pathStats);
            }
            if (pathStats.requestIds.size() >= 10) {
                if ((Integer)pathStats.requestIds.get(pathStats.requestIds.size() - 1) != 0) {
                    pathStats.requestIds.add(0);
                }
            } else {
                pathStats.requestIds.add(i + 1);
            }
            for (StatsProtos.AggregateRpcStatsProto aggregateStat : requestStat.getRpcStatsList()) {
                String rpcKey = aggregateStat.getServiceCallName();
                long totalCalls = aggregateStat.getTotalAmountOfCalls();
                long costMicrodollars = aggregateStat.getTotalCostOfCallsMicrodollars();
                totalCostMicrodollars = totalCostMicrodollars.add(new BigDecimal(costMicrodollars));
                RpcStats rpcStats = (RpcStats)statsByRpc.get(rpcKey);
                if (rpcStats == null) {
                    rpcStats = new RpcStats(rpcKey);
                    statsByRpc.put(rpcKey, rpcStats);
                }
                BaseStats baseStats = pathStats;
                Long.valueOf(baseStats.numRpcs + totalCalls);
                baseStats.numRpcs = baseStats.numRpcs;
                pathStats.rpcCostMicrodollars += costMicrodollars;
                baseStats = rpcStats;
                Long.valueOf(((RpcStats)baseStats).numRpcs + totalCalls);
                ((RpcStats)baseStats).numRpcs = ((RpcStats)baseStats).numRpcs;
                rpcStats.rpcCostMicrodollars += costMicrodollars;
                RpcStats rpcStatsForPath = (RpcStats)pathStats.rpcStats.get(rpcKey);
                if (rpcStatsForPath == null) {
                    rpcStatsForPath = new RpcStats(rpcKey);
                    pathStats.rpcStats.put(rpcKey, rpcStatsForPath);
                }
                RpcStats rpcStats2 = rpcStatsForPath;
                Long.valueOf(rpcStats2.numRpcs + totalCalls);
                rpcStats2.numRpcs = rpcStats2.numRpcs;
                rpcStatsForPath.rpcCostMicrodollars += costMicrodollars;
                PathStats pathStatsForRpc = (PathStats)rpcStats.pathStats.get(pathKey);
                if (pathStatsForRpc == null) {
                    pathStatsForRpc = new PathStats(pathKey);
                    rpcStats.pathStats.put(pathKey, pathStatsForRpc);
                }
                PathStats pathStats2 = pathStatsForRpc;
                Long.valueOf(pathStats2.numRpcs + totalCalls);
                pathStats2.numRpcs = pathStats2.numRpcs;
                pathStatsForRpc.rpcCostMicrodollars += costMicrodollars;
                StatsUtil.updateBilledOps(pathStats.billedOps, aggregateStat.getTotalBilledOpsList());
                StatsUtil.updateBilledOps(rpcStats.billedOps, aggregateStat.getTotalBilledOpsList());
                StatsUtil.updateBilledOps(rpcStatsForPath.billedOps, aggregateStat.getTotalBilledOpsList());
                StatsUtil.updateBilledOps(pathStatsForRpc.billedOps, aggregateStat.getTotalBilledOpsList());
            }
        }
        ArrayList rpcStatsTuples = new ArrayList();
        for (RpcStats rpcStats : statsByRpc.values()) {
            List<List<Object>> pathStatsTupleOrderedByRpc = StatsUtil.asTupleOrderedByNumRpcs(rpcStats.pathStats, totalCostMicrodollars);
            ArrayList<Object> rpcStatTuple = new ArrayList<Object>();
            rpcStatTuple.add(rpcStats.rpcName);
            rpcStatTuple.add(rpcStats.numRpcs);
            rpcStatTuple.add(rpcStats.rpcCostMicrodollars);
            rpcStatTuple.add(rpcStats.billedOps);
            rpcStatTuple.add(StatsUtil.asPercentageOf(rpcStats.rpcCostMicrodollars, totalCostMicrodollars));
            rpcStatTuple.add(pathStatsTupleOrderedByRpc);
            rpcStatsTuples.add(rpcStatTuple);
        }
        Collections.sort(rpcStatsTuples, BY_FIRST_ELEMENT);
        ArrayList rpcStatsTuplesOrderedByRpcCount = new ArrayList(rpcStatsTuples);
        Collections.sort(rpcStatsTuplesOrderedByRpcCount, BY_SECOND_ELEMENT);
        ArrayList pathStatsTuples = new ArrayList();
        for (PathStats pathStats : statsByPath.values()) {
            List<List<Object>> rpcStatsTupleOrderedByPath = StatsUtil.asTupleOrderedByNumRpcs(pathStats.rpcStats, totalCostMicrodollars);
            long rpcCount = 0L;
            long rpcCostMicrodollars = 0L;
            for (List<Object> rpcStatsTuple : rpcStatsTupleOrderedByPath) {
                rpcCount += ((Long)rpcStatsTuple.get(1)).longValue();
                rpcCostMicrodollars += ((Long)rpcStatsTuple.get(2)).longValue();
            }
            ArrayList<Object> pathStatTuple = new ArrayList<Object>();
            pathStatTuple.add(pathStats.path);
            pathStatTuple.add(rpcCount);
            pathStatTuple.add(rpcCostMicrodollars);
            pathStatTuple.add(pathStats.billedOps);
            pathStatTuple.add(StatsUtil.asPercentageOf(rpcCostMicrodollars, totalCostMicrodollars));
            pathStatTuple.add(pathStats.requestIds.size());
            pathStatTuple.add(pathStats.requestIds);
            pathStatTuple.add(rpcStatsTupleOrderedByPath);
            pathStatsTuples.add(pathStatTuple);
        }
        Collections.sort(pathStatsTuples, BY_FIRST_ELEMENT);
        ArrayList pathStatsTuplesOrderedByRpcCount = new ArrayList(pathStatsTuples);
        Collections.sort(pathStatsTuplesOrderedByRpcCount, BY_SECOND_ELEMENT);
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("requests", augmented);
        values.put("allstats_by_count", rpcStatsTuplesOrderedByRpcCount);
        values.put("pathstats_by_count", pathStatsTuplesOrderedByRpcCount);
        values.put("has_cost_data", Boolean.TRUE);
        return values;
    }

    static Map<String, Object> createDetailedStats(StatsProtos.RequestStatProto data) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("record", StatsUtil.augmentProto(data));
        parameters.put("file_url", false);
        HashMap<String, DetailedRpcStats> statsByRpc = new HashMap<String, DetailedRpcStats>();
        for (StatsProtos.IndividualRpcStatsProto rpcStat : data.getIndividualStatsList()) {
            String rpcName = rpcStat.getServiceCallName();
            DetailedRpcStats statsForRpc = (DetailedRpcStats)statsByRpc.get(rpcName);
            if (statsForRpc == null) {
                statsForRpc = new DetailedRpcStats(rpcName);
                statsByRpc.put(rpcName, statsForRpc);
            }
            DetailedRpcStats detailedRpcStats = statsForRpc;
            Long l = detailedRpcStats.numRpcs;
            Long l2 = detailedRpcStats.numRpcs = Long.valueOf(detailedRpcStats.numRpcs + 1L);
            statsForRpc.durationMillis += rpcStat.getDurationMilliseconds();
            statsForRpc.apiMcycles += rpcStat.getApiMcycles();
            statsForRpc.rpcCostMicrodollars += rpcStat.getCallCostMicrodollars();
            StatsUtil.updateBilledOps(statsForRpc.billedOps, rpcStat.getBilledOpsList());
        }
        ArrayList rpcStatsSortedByCount = new ArrayList();
        for (Map.Entry entry : statsByRpc.entrySet()) {
            ArrayList<Object> tuple = new ArrayList<Object>();
            tuple.add(entry.getKey());
            DetailedRpcStats detailedStats = (DetailedRpcStats)entry.getValue();
            tuple.add(detailedStats.numRpcs);
            tuple.add(detailedStats.durationMillis);
            tuple.add(StatsUtil.megaCyclesToMilliseconds(detailedStats.apiMcycles));
            tuple.add(detailedStats.rpcCostMicrodollars);
            tuple.add(detailedStats.billedOps);
            rpcStatsSortedByCount.add(tuple);
        }
        Collections.sort(rpcStatsSortedByCount, BY_SECOND_ELEMENT);
        parameters.put("rpcstats_by_count", rpcStatsSortedByCount);
        long realTotal = 0L;
        long apiTotalMcycles = 0L;
        for (StatsProtos.IndividualRpcStatsProto stat : data.getIndividualStatsList()) {
            realTotal += stat.getDurationMilliseconds();
            apiTotalMcycles += stat.getApiMcycles();
        }
        long apiTotal = StatsUtil.megaCyclesToMilliseconds(apiTotalMcycles);
        long chargedTotal = StatsUtil.megaCyclesToMilliseconds(data.getProcessorMcycles() + apiTotalMcycles);
        parameters.put("real_total", realTotal);
        parameters.put("api_total", apiTotal);
        parameters.put("charged_total", chargedTotal);
        parameters.put("has_cost_data", Boolean.TRUE);
        return parameters;
    }

    private static Map<StatsProtos.BilledOpProto.BilledOp, Integer> updateBilledOps(Map<StatsProtos.BilledOpProto.BilledOp, Integer> billedOps, List<StatsProtos.BilledOpProto> billedOpsList) {
        for (StatsProtos.BilledOpProto proto : billedOpsList) {
            if (billedOps.get((Object)proto.getOp()) == null) {
                billedOps.put(proto.getOp(), 0);
            }
            billedOps.put(proto.getOp(), billedOps.get((Object)proto.getOp()) + proto.getNumOps());
        }
        return billedOps;
    }

    private static final class BilledOpsMap
    extends TreeMap<StatsProtos.BilledOpProto.BilledOp, Integer> {
        private BilledOpsMap() {
        }

        @Override
        public String toString() {
            return Joiner.on(", ").join(Iterables.transform(this.entrySet(), new Function<Map.Entry<StatsProtos.BilledOpProto.BilledOp, Integer>, String>(){

                @Override
                public String apply(Map.Entry<StatsProtos.BilledOpProto.BilledOp, Integer> entry) {
                    return String.format("%s:%d", new Object[]{entry.getKey(), entry.getValue()});
                }
            }));
        }
    }

    private static class DetailedRpcStats
    extends RpcStats {
        long durationMillis;
        long apiMcycles;

        private DetailedRpcStats(String rpcName) {
            super(rpcName);
        }
    }

    private static class RpcStats
    extends BaseStats {
        private final String rpcName;
        private final Map<String, PathStats> pathStats = Maps.newHashMap();

        private RpcStats(String rpcName) {
            this.rpcName = rpcName;
        }
    }

    private static class PathStats
    extends BaseStats {
        private final String path;
        private final List<Integer> requestIds = new ArrayList<Integer>();
        private final Map<String, RpcStats> rpcStats = Maps.newHashMap();

        private PathStats(String path) {
            this.path = path;
        }
    }

    private static class BaseStats {
        Long numRpcs = 0L;
        long rpcCostMicrodollars;
        final Map<StatsProtos.BilledOpProto.BilledOp, Integer> billedOps = new BilledOpsMap();

        private BaseStats() {
        }
    }
}

