/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.tools.mapreduce.EndSliceEventSource;
import java.util.ArrayList;
import java.util.Collection;

public class DatastoreMutationPool {
    private static final int DEFAULT_COUNT_LIMIT = 100;
    private static final int DEFAULT_BYTES_LIMIT = 262144;
    private final DatastoreService ds;
    private final int countLimit;
    private final int bytesLimit;
    private final Collection<Entity> puts = new ArrayList<Entity>();
    private int putsBytes = 0;
    private final Collection<Key> deletes = new ArrayList<Key>();
    private int deletesBytes = 0;

    public DatastoreMutationPool(EndSliceEventSource context) {
        this(DatastoreServiceFactory.getDatastoreService(), context, 100, 262144);
    }

    public DatastoreMutationPool(DatastoreService ds, EndSliceEventSource context, int countLimit, int bytesLimit) {
        this.ds = ds;
        this.countLimit = countLimit;
        this.bytesLimit = bytesLimit;
        context.addEndSliceListener(new Runnable(){

            @Override
            public void run() {
                DatastoreMutationPool.this.flush();
            }
        });
    }

    public void delete(Key key) {
        int bytesHere = KeyFactory.keyToString((Key)key).length();
        if (this.deletesBytes + bytesHere >= this.bytesLimit) {
            this.flushDeletes();
        }
        this.deletesBytes += bytesHere;
        this.deletes.add(key);
        if (this.deletes.size() >= this.countLimit) {
            this.flushDeletes();
        }
    }

    public void put(Entity entity) {
        int bytesHere = EntityTranslator.convertToPb((Entity)entity).getSerializedSize();
        if (this.putsBytes + bytesHere >= this.bytesLimit) {
            this.flushPuts();
        }
        this.putsBytes += bytesHere;
        this.puts.add(entity);
        if (this.puts.size() >= this.countLimit) {
            this.flushPuts();
        }
    }

    public void flush() {
        if (!this.puts.isEmpty()) {
            this.flushPuts();
        }
        if (!this.deletes.isEmpty()) {
            this.flushDeletes();
        }
    }

    private void flushDeletes() {
        this.ds.delete(this.deletes);
        this.deletes.clear();
        this.deletesBytes = 0;
    }

    private void flushPuts() {
        this.ds.put(this.puts);
        this.puts.clear();
        this.putsBytes = 0;
    }
}

