/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce;

import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.tools.mapreduce.Input;
import com.google.appengine.tools.mapreduce.Mapper;
import com.google.appengine.tools.mapreduce.Marshaller;
import com.google.appengine.tools.mapreduce.Output;
import com.google.appengine.tools.mapreduce.Reducer;
import java.io.Serializable;

public final class MapReduceSpecification<I, K, V, O, R>
implements Serializable {
    private static final long serialVersionUID = 4773121986957455423L;
    private String jobName;
    private Input<I> input;
    private Mapper<I, K, V> mapper;
    private Marshaller<K> intermediateKeyMarshaller;
    private Marshaller<V> intermediateValueMarshaller;
    private Reducer<K, V, O> reducer;
    private Output<O, R> output;

    public static <I, K, V, O, R> MapReduceSpecification<I, K, V, O, R> of(String jobName, Input<I> input, Mapper<I, K, V> mapper, Marshaller<K> intermediateKeyMarshaller, Marshaller<V> intermediateValueMarshaller, Reducer<K, V, O> reducer, Output<O, R> output) {
        return new MapReduceSpecification<I, K, V, O, R>(jobName, input, mapper, intermediateKeyMarshaller, intermediateValueMarshaller, reducer, output);
    }

    private MapReduceSpecification(String jobName, Input<I> input, Mapper<I, K, V> mapper, Marshaller<K> intermediateKeyMarshaller, Marshaller<V> intermediateValueMarshaller, Reducer<K, V, O> reducer, Output<O, R> output) {
        this.jobName = Preconditions.checkNotNull(jobName, "Null jobName");
        this.input = Preconditions.checkNotNull(input, "Null input");
        this.mapper = Preconditions.checkNotNull(mapper, "Null mapper");
        this.intermediateKeyMarshaller = Preconditions.checkNotNull(intermediateKeyMarshaller, "Null intermediateKeyMarshaller");
        this.intermediateValueMarshaller = Preconditions.checkNotNull(intermediateValueMarshaller, "Null intermediateValueMarshaller");
        this.reducer = Preconditions.checkNotNull(reducer, "Null reducer");
        this.output = Preconditions.checkNotNull(output, "Null output");
    }

    public String getJobName() {
        return this.jobName;
    }

    public MapReduceSpecification<I, K, V, O, R> setJobName(String jobName) {
        this.jobName = Preconditions.checkNotNull(jobName, "Null jobName");
        return this;
    }

    public Input<I> getInput() {
        return this.input;
    }

    public MapReduceSpecification<I, K, V, O, R> setInput(Input<I> input) {
        this.input = Preconditions.checkNotNull(input, "Null input");
        return this;
    }

    public Mapper<I, K, V> getMapper() {
        return this.mapper;
    }

    public MapReduceSpecification<I, K, V, O, R> setMapper(Mapper<I, K, V> mapper) {
        this.mapper = Preconditions.checkNotNull(mapper, "Null mapper");
        return this;
    }

    public Marshaller<K> getIntermediateKeyMarshaller() {
        return this.intermediateKeyMarshaller;
    }

    public MapReduceSpecification<I, K, V, O, R> setIntermediateKeyMarshaller(Marshaller<K> intermediateKeyMarshaller) {
        this.intermediateKeyMarshaller = Preconditions.checkNotNull(intermediateKeyMarshaller, "Null intermediateKeyMarshaller");
        return this;
    }

    public Marshaller<V> getIntermediateValueMarshaller() {
        return this.intermediateValueMarshaller;
    }

    public MapReduceSpecification<I, K, V, O, R> setIntermediateValueMarshaller(Marshaller<V> intermediateValueMarshaller) {
        this.intermediateValueMarshaller = Preconditions.checkNotNull(intermediateValueMarshaller, "Null intermediateValueMarshaller");
        return this;
    }

    public Reducer<K, V, O> getReducer() {
        return this.reducer;
    }

    public MapReduceSpecification<I, K, V, O, R> setReducer(Reducer<K, V, O> reducer) {
        this.reducer = Preconditions.checkNotNull(reducer, "Null reducer");
        return this;
    }

    public Output<O, R> getOutput() {
        return this.output;
    }

    public MapReduceSpecification<I, K, V, O, R> setOutput(Output<O, R> output) {
        this.output = Preconditions.checkNotNull(output, "Null output");
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.jobName + ", " + this.input + ", " + this.mapper + ", " + this.reducer + ", " + this.output + ")";
    }
}

