/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce;

import com.google.appengine.tools.mapreduce.KeyValue;
import com.google.appengine.tools.mapreduce.Marshaller;
import com.google.appengine.tools.mapreduce.impl.util.SerializationUtil;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Marshallers {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private Marshallers() {
    }

    public static <T extends Serializable> Marshaller<T> getSerializationMarshaller() {
        return new SerializationMarshaller();
    }

    public static Marshaller<String> getStringMarshaller() {
        return new SerializationMarshaller<String>();
    }

    public static Marshaller<Long> getLongMarshaller() {
        return new LongMarshaller();
    }

    public static Marshaller<Integer> getIntegerMarshaller() {
        return new IntegerMarshaller();
    }

    public static Marshaller<Void> getVoidMarshaller() {
        return new VoidMarshaller();
    }

    public static <K, V> Marshaller<KeyValue<K, V>> getKeyValueMarshaller(Marshaller<K> keyMarshaller, Marshaller<V> valueMarshaller) {
        return new KeyValueMarshaller(keyMarshaller, valueMarshaller);
    }

    private static class KeyValueMarshaller<K, V>
    extends Marshaller<KeyValue<K, V>> {
        private static final long serialVersionUID = 494784801710376720L;
        private final Marshaller<K> keyMarshaller;
        private final Marshaller<V> valueMarshaller;

        private KeyValueMarshaller(Marshaller<K> keyMarshaller, Marshaller<V> valueMarshaller) {
            this.keyMarshaller = keyMarshaller;
            this.valueMarshaller = valueMarshaller;
        }

        @Override
        public ByteBuffer toBytes(KeyValue<K, V> pair) {
            ByteBuffer key = this.keyMarshaller.toBytes(pair.getKey());
            ByteBuffer value = this.valueMarshaller.toBytes(pair.getValue());
            ByteBuffer out = ByteBuffer.allocate(4 + key.remaining() + value.remaining());
            out.putInt(key.remaining());
            out.put(key);
            out.put(value);
            out.rewind();
            return out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public KeyValue<K, V> fromBytes(ByteBuffer in) throws IOException {
            K key;
            in.order(ByteOrder.BIG_ENDIAN);
            int keyLength = in.getInt();
            int oldLimit = in.limit();
            try {
                in.limit(in.position() + keyLength);
                key = this.keyMarshaller.fromBytes(in.slice());
            }
            finally {
                in.limit(oldLimit);
            }
            in.position(in.position() + keyLength);
            V value = this.valueMarshaller.fromBytes(in.slice());
            return KeyValue.of(key, value);
        }
    }

    private static class VoidMarshaller
    extends Marshaller<Void> {
        private static final long serialVersionUID = 534040781414531156L;

        private VoidMarshaller() {
        }

        @Override
        public ByteBuffer toBytes(Void x) {
            return ByteBuffer.wrap(EMPTY_BYTE_ARRAY);
        }

        @Override
        public Void fromBytes(ByteBuffer in) throws IOException {
            if (in.remaining() != 0) {
                throw new IOException("Expected 0 bytes, not " + in.remaining());
            }
            return null;
        }
    }

    private static class IntegerMarshaller
    extends Marshaller<Integer> {
        private static final long serialVersionUID = 116841732914441971L;

        private IntegerMarshaller() {
        }

        @Override
        public ByteBuffer toBytes(Integer x) {
            ByteBuffer out = ByteBuffer.allocate(4).putInt(x);
            out.rewind();
            return out;
        }

        @Override
        public Integer fromBytes(ByteBuffer in) throws IOException {
            if (in.remaining() != 4) {
                throw new IOException("Expected 4 bytes, not " + in.remaining());
            }
            in.order(ByteOrder.BIG_ENDIAN);
            return in.getInt();
        }
    }

    private static class LongMarshaller
    extends Marshaller<Long> {
        private static final long serialVersionUID = 646739857959433591L;

        private LongMarshaller() {
        }

        @Override
        public ByteBuffer toBytes(Long x) {
            ByteBuffer out = ByteBuffer.allocate(8).putLong(x);
            out.rewind();
            return out;
        }

        @Override
        public Long fromBytes(ByteBuffer in) throws IOException {
            if (in.remaining() != 8) {
                throw new IOException("Expected 8 bytes, not " + in.remaining());
            }
            in.order(ByteOrder.BIG_ENDIAN);
            return in.getLong();
        }
    }

    private static class SerializationMarshaller<T extends Serializable>
    extends Marshaller<T> {
        private static final long serialVersionUID = 401446902678227352L;

        private SerializationMarshaller() {
        }

        @Override
        public ByteBuffer toBytes(T object) {
            return ByteBuffer.wrap(SerializationUtil.serializeToByteArrayNoHeader(object));
        }

        @Override
        public T fromBytes(ByteBuffer in) throws IOException {
            return (T)((Serializable)SerializationUtil.deserializeFromByteBufferNoHeader(in));
        }
    }
}

