/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl;

import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.labs.repackaged.com.google.common.collect.Maps;
import com.google.appengine.tools.mapreduce.WorkerContext;
import com.google.appengine.tools.mapreduce.impl.CountersImpl;
import com.google.appengine.tools.mapreduce.impl.WorkerResult;
import com.google.appengine.tools.mapreduce.impl.WorkerShardState;
import com.google.appengine.tools.mapreduce.impl.WorkerShardTask;
import com.google.appengine.tools.mapreduce.impl.shardedjob.ShardedJobController;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class AbstractWorkerController<I, O, C extends WorkerContext>
implements ShardedJobController<WorkerShardTask<I, O, C>, WorkerResult<O>> {
    private static final long serialVersionUID = 887646042087205202L;
    private static final Logger log = Logger.getLogger(AbstractWorkerController.class.getName());
    private final String shardedJobName;

    public AbstractWorkerController(String shardedJobName) {
        this.shardedJobName = Preconditions.checkNotNull(shardedJobName, "Null shardedJobName");
    }

    public String getShardedJobName() {
        return this.shardedJobName;
    }

    private void checkDisjoint(Set<?> small, Set<?> large) {
        for (Object x : small) {
            Preconditions.checkState(!large.contains(x), "Not disjoint: %s, %s, %s", x, small, large);
        }
    }

    @Override
    public WorkerResult<O> combineResults(Iterable<WorkerResult<O>> partialResults) {
        HashMap closedWriters = Maps.newHashMap();
        HashMap<Integer, WorkerShardState> workerShardStates = Maps.newHashMap();
        CountersImpl counters = new CountersImpl();
        for (WorkerResult<O> r : partialResults) {
            this.checkDisjoint(r.getClosedWriters().keySet(), closedWriters.keySet());
            closedWriters.putAll(r.getClosedWriters());
            counters.addAll(r.getCounters());
            for (Map.Entry<Integer, WorkerShardState> entry : r.getWorkerShardStates().entrySet()) {
                int i = entry.getKey();
                WorkerShardState a = (WorkerShardState)workerShardStates.get(i);
                WorkerShardState b = entry.getValue();
                if (a == null) {
                    workerShardStates.put(i, b);
                    continue;
                }
                workerShardStates.put(i, new WorkerShardState(a.getWorkerCallCount() + b.getWorkerCallCount(), Math.max(a.getMostRecentUpdateTimeMillis(), b.getMostRecentUpdateTimeMillis()), b.getLastWorkItem()));
            }
        }
        return new WorkerResult(closedWriters, workerShardStates, counters);
    }

    @Override
    public abstract void completed(WorkerResult<O> var1);
}

