/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl;

import com.google.appengine.labs.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.labs.repackaged.com.google.common.collect.Ordering;
import com.google.appengine.tools.mapreduce.Counter;
import com.google.appengine.tools.mapreduce.Counters;
import java.io.Serializable;
import java.util.HashMap;

public class CountersImpl
implements Counters {
    private static final long serialVersionUID = -8499952345096458550L;
    private final HashMap<String, CounterImpl> values = new HashMap();

    public String toString() {
        StringBuilder out = new StringBuilder(this.getClass().getSimpleName() + "(");
        String separator = "";
        for (String key : Ordering.natural().sortedCopy(this.values.keySet())) {
            out.append(separator + this.values.get(key));
            separator = ", ";
        }
        return out + ")";
    }

    @Override
    public Counter getCounter(String name) {
        CounterImpl counter = this.values.get(name);
        if (counter == null) {
            counter = new CounterImpl(name);
            this.values.put(name, counter);
        }
        return counter;
    }

    @Override
    public Iterable<? extends Counter> getCounters() {
        return Iterables.unmodifiableIterable(this.values.values());
    }

    public void addAll(Counters other) {
        for (Counter counter : other.getCounters()) {
            this.getCounter(counter.getName()).increment(counter.getValue());
        }
    }

    private static class CounterImpl
    implements Counter,
    Serializable {
        private static final long serialVersionUID = 5872696485441192885L;
        private final String name;
        private long value = 0L;

        CounterImpl(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public void increment(long delta) {
            this.value += delta;
        }
    }
}

