/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreServiceFactory;
import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.labs.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.labs.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.labs.repackaged.com.google.common.collect.Lists;
import com.google.appengine.tools.mapreduce.impl.util.FileUtil;
import com.google.appengine.tools.pipeline.Job1;
import com.google.appengine.tools.pipeline.JobSetting;
import com.google.appengine.tools.pipeline.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class DeleteFilesJob
extends Job1<Void, List<AppEngineFile>> {
    private static final long serialVersionUID = 701830786556967921L;
    private static final Logger log = Logger.getLogger(DeleteFilesJob.class.getName());
    private static final int MAX_BLOB_DELETIONS_PER_RPC = 1;
    private static final int MAX_BLOB_DELETIONS_PER_JOB = 20;
    private final String description;

    public DeleteFilesJob(String description) {
        this.description = description;
    }

    public String toString() {
        return "DeleteFilesJob(" + this.description + ")";
    }

    @Override
    public Value<Void> run(List<AppEngineFile> filesToDelete) {
        Iterable<List<AppEngineFile>> batches = Iterables.partition(filesToDelete, 20);
        for (List<AppEngineFile> batch : batches) {
            ImmutableList<AppEngineFile> copy = ImmutableList.copyOf(batch);
            this.futureCall(new DeleteBlobsJob(), DeleteFilesJob.immediate(copy), new JobSetting[0]);
        }
        return null;
    }

    private static class DeleteBlobsJob
    extends Job1<Void, List<AppEngineFile>> {
        private static final long serialVersionUID = 832681572879957125L;

        private DeleteBlobsJob() {
        }

        @Override
        public Value<Void> run(List<AppEngineFile> filesToDelete) {
            ArrayList<BlobKey> keys = Lists.newArrayListWithCapacity(filesToDelete.size());
            for (AppEngineFile appEngineFile : filesToDelete) {
                Preconditions.checkArgument(appEngineFile.getFileSystem() == AppEngineFile.FileSystem.BLOBSTORE, "%s: File has unexpected file system: %s", this, appEngineFile);
                keys.add(FileUtil.getBlobKey(appEngineFile));
            }
            for (List list : Lists.partition(keys, 1)) {
                log.info("Deleting " + list);
                BlobstoreServiceFactory.getBlobstoreService().delete(list.toArray(new BlobKey[0]));
            }
            return null;
        }
    }
}

