/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl;

import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileService;
import com.google.appengine.api.files.FileServiceFactory;
import com.google.appengine.api.files.FileServicePb;
import com.google.appengine.api.files.RecordReadChannel;
import com.google.appengine.labs.repackaged.com.google.common.base.Function;
import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.labs.repackaged.com.google.common.collect.AbstractIterator;
import com.google.appengine.labs.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.labs.repackaged.com.google.common.collect.Iterators;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.tools.mapreduce.Input;
import com.google.appengine.tools.mapreduce.InputReader;
import com.google.appengine.tools.mapreduce.KeyValue;
import com.google.appengine.tools.mapreduce.Marshaller;
import com.google.appengine.tools.mapreduce.ReducerInput;
import com.google.appengine.tools.mapreduce.impl.NonSpammingRecordReadChannel;
import com.google.appengine.tools.mapreduce.impl.ReducerInputs;
import com.google.appengine.tools.mapreduce.impl.util.SerializationUtil;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

public class IntermediateInput<K, V>
extends Input<KeyValue<K, ReducerInput<V>>> {
    private static final long serialVersionUID = 970064558391741661L;
    private static final Logger log = Logger.getLogger(IntermediateInput.class.getName());
    private static final FileService FILE_SERVICE = FileServiceFactory.getFileService();
    private final List<AppEngineFile> files;
    private final Marshaller<K> keyMarshaller;
    private final Marshaller<V> valueMarshaller;

    public IntermediateInput(List<AppEngineFile> files, Marshaller<K> keyMarshaller, Marshaller<V> valueMarshaller) {
        this.files = ImmutableList.copyOf(files);
        this.keyMarshaller = Preconditions.checkNotNull(keyMarshaller, "Null keyMarshaller");
        this.valueMarshaller = Preconditions.checkNotNull(valueMarshaller, "Null valueMarshaller");
    }

    @Override
    public List<? extends InputReader<KeyValue<K, ReducerInput<V>>>> createReaders() {
        ImmutableList.Builder out = ImmutableList.builder();
        for (AppEngineFile file : this.files) {
            out.add(new Reader<K, V>(file, this.keyMarshaller, this.valueMarshaller));
        }
        return out.build();
    }

    static class Reader<K, V>
    extends InputReader<KeyValue<K, ReducerInput<V>>> {
        private static final long serialVersionUID = 993392238306084318L;
        private final AppEngineFile file;
        private long posBytes = 0L;
        private Marshaller<K> keyMarshaller;
        private Marshaller<V> valueMarshaller;
        private transient RecordReadChannel channel;

        Reader(AppEngineFile file, Marshaller<K> keyMarshaller, Marshaller<V> valueMarshaller) {
            this.file = Preconditions.checkNotNull(file, "Null file");
            this.keyMarshaller = Preconditions.checkNotNull(keyMarshaller, "Null keyMarshaller");
            this.valueMarshaller = Preconditions.checkNotNull(valueMarshaller, "Null valueMarshaller");
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.file + " at position " + this.posBytes + ")";
        }

        @Override
        public Double getProgress() {
            return null;
        }

        RecordReadChannel openChannel() {
            try {
                return new NonSpammingRecordReadChannel(FILE_SERVICE.openReadChannel(this.file, false));
            }
            catch (IOException e) {
                throw new RuntimeException(this + ": opening read channel failed", e);
            }
        }

        private void ensureOpen() {
            this.channel = this.openChannel();
            try {
                this.channel.position(this.posBytes);
            }
            catch (IOException e) {
                throw new RuntimeException(this + ": position(" + this.posBytes + ") failed", e);
            }
        }

        private FileServicePb.KeyValues readProto() {
            ByteBuffer record;
            this.ensureOpen();
            try {
                record = this.channel.readRecord();
            }
            catch (EOFException e) {
                record = null;
            }
            catch (IOException e) {
                throw new RuntimeException(this + ": Failed to read record", e);
            }
            try {
                this.posBytes = this.channel.position();
            }
            catch (IOException e) {
                throw new RuntimeException(this + ": Failed to get position()", e);
            }
            if (record == null) {
                return null;
            }
            byte[] bytes = SerializationUtil.getBytes(record);
            try {
                return FileServicePb.KeyValues.parseFrom((byte[])bytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(this + ": Failed to parse protobuf: " + SerializationUtil.prettyBytes(bytes), e);
            }
        }

        private Iterator<V> makeIterator(FileServicePb.KeyValues proto) {
            return Iterators.transform(proto.getValueList().iterator(), new Function<ByteString, V>(){

                @Override
                public V apply(ByteString in) {
                    try {
                        return Reader.this.valueMarshaller.fromBytes(in.asReadOnlyByteBuffer());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(Reader.this + ": " + Reader.this.valueMarshaller + " failed to parse value: " + in, e);
                    }
                }
            });
        }

        @Override
        public KeyValue<K, ReducerInput<V>> next() {
            K key;
            FileServicePb.KeyValues proto = this.readProto();
            if (proto == null) {
                throw new NoSuchElementException();
            }
            try {
                key = this.keyMarshaller.fromBytes(proto.getKey().asReadOnlyByteBuffer());
            }
            catch (IOException e) {
                throw new RuntimeException(this + ": " + this.keyMarshaller + " failed to parse key from " + proto, e);
            }
            return KeyValue.of(key, ReducerInputs.fromIterator(Iterators.concat(this.makeIterator(proto), proto.getPartial() ? Iterators.concat(new IteratorIterator(proto.getKey())) : Iterators.emptyIterator())));
        }

        private class IteratorIterator
        extends AbstractIterator<Iterator<V>> {
            private final ByteString expectedKey;
            private boolean previousWasPartial = true;

            IteratorIterator(ByteString expectedKey) {
                this.expectedKey = Preconditions.checkNotNull(expectedKey, "Null expectedKey");
            }

            public String toString() {
                return this.getClass().getSimpleName() + "(" + Reader.this + ")";
            }

            @Override
            protected Iterator<V> computeNext() {
                if (!this.previousWasPartial) {
                    return (Iterator)this.endOfData();
                }
                FileServicePb.KeyValues proto = Reader.this.readProto();
                Preconditions.checkState(proto != null, "%s: Unexpected EOF, previous KeyValues was partial; key=%s", this, this.expectedKey);
                Preconditions.checkState(this.expectedKey.equals((Object)proto.getKey()), "%s: Expected key %s, got %s", this, this.expectedKey, proto.getKey());
                this.previousWasPartial = proto.getPartial();
                return Reader.this.makeIterator(proto);
            }
        }
    }
}

