/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl;

import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileService;
import com.google.appengine.api.files.FileServiceFactory;
import com.google.appengine.api.files.FileServicePb;
import com.google.appengine.api.files.RecordWriteChannel;
import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.labs.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.mapreduce.KeyValue;
import com.google.appengine.tools.mapreduce.Marshaller;
import com.google.appengine.tools.mapreduce.Output;
import com.google.appengine.tools.mapreduce.OutputWriter;
import com.google.appengine.tools.mapreduce.impl.util.FileUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.logging.Logger;

public class IntermediateOutput<K, V>
extends Output<KeyValue<K, V>, List<AppEngineFile>> {
    private static final long serialVersionUID = 207899202516112458L;
    private static final Logger log = Logger.getLogger(IntermediateOutput.class.getName());
    private static final FileService FILE_SERVICE = FileServiceFactory.getFileService();
    private final String mrJobId;
    private final int shardCount;
    private final Marshaller<K> keyMarshaller;
    private final Marshaller<V> valueMarshaller;

    public IntermediateOutput(String mrJobId, int shardCount, Marshaller<K> keyMarshaller, Marshaller<V> valueMarshaller) {
        this.mrJobId = Preconditions.checkNotNull(mrJobId, "Null mrJobId");
        this.shardCount = shardCount;
        this.keyMarshaller = Preconditions.checkNotNull(keyMarshaller, "Null keyMarshaller");
        this.valueMarshaller = Preconditions.checkNotNull(valueMarshaller, "Null valueMarshaller");
    }

    @Override
    public List<? extends OutputWriter<KeyValue<K, V>>> createWriters() {
        ImmutableList.Builder out = ImmutableList.builder();
        for (int i = 0; i < this.shardCount; ++i) {
            out.add(new Writer<K, V>(this.mrJobId, i, this.keyMarshaller, this.valueMarshaller));
        }
        return out.build();
    }

    @Override
    public List<AppEngineFile> finish(List<? extends OutputWriter<KeyValue<K, V>>> writers) {
        ImmutableList.Builder out = ImmutableList.builder();
        for (OutputWriter<KeyValue<K, V>> w : writers) {
            Writer writer = (Writer)w;
            if (writer.fileReadHandle == null) continue;
            out.add(writer.fileReadHandle);
        }
        return out.build();
    }

    private static class Writer<K, V>
    extends OutputWriter<KeyValue<K, V>> {
        private static final long serialVersionUID = 592636863384442324L;
        private final String mrJobId;
        private final int mapShardNumber;
        private final Marshaller<K> keyMarshaller;
        private final Marshaller<V> valueMarshaller;
        private AppEngineFile file = null;
        private AppEngineFile fileReadHandle = null;
        private transient RecordWriteChannel channel;

        public Writer(String mrJobId, int mapShardNumber, Marshaller<K> keyMarshaller, Marshaller<V> valueMarshaller) {
            this.mrJobId = Preconditions.checkNotNull(mrJobId, "Null mrJobId");
            this.mapShardNumber = mapShardNumber;
            this.keyMarshaller = Preconditions.checkNotNull(keyMarshaller, "Null keyMarshaller");
            this.valueMarshaller = Preconditions.checkNotNull(valueMarshaller, "Null valueMarshaller");
        }

        private void ensureOpen() throws IOException {
            if (this.channel != null) {
                return;
            }
            if (this.file == null) {
                this.file = FILE_SERVICE.createNewBlobFile("application/vnd.appengine.mapreduce.map-output.records", this.mrJobId + ": map output, shard " + this.mapShardNumber);
            }
            this.channel = FILE_SERVICE.openRecordWriteChannel(this.file, false);
        }

        @Override
        public void write(KeyValue<K, V> pair) throws IOException {
            this.ensureOpen();
            FileServicePb.KeyValue.Builder b = FileServicePb.KeyValue.newBuilder();
            b.setKey(ByteString.copyFrom((ByteBuffer)this.keyMarshaller.toBytes(pair.getKey())));
            b.setValue(ByteString.copyFrom((ByteBuffer)this.valueMarshaller.toBytes(pair.getValue())));
            this.channel.write(ByteBuffer.wrap(b.build().toByteArray()), null);
        }

        @Override
        public void endSlice() throws IOException {
            if (this.channel != null) {
                this.channel.close();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.file != null) {
                this.fileReadHandle = FileUtil.ensureFinalized(this.file);
            }
        }
    }
}

