/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl;

import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.tools.mapreduce.Counters;
import com.google.appengine.tools.mapreduce.InputReader;
import com.google.appengine.tools.mapreduce.KeyValue;
import com.google.appengine.tools.mapreduce.Mapper;
import com.google.appengine.tools.mapreduce.MapperContext;
import com.google.appengine.tools.mapreduce.OutputWriter;
import com.google.appengine.tools.mapreduce.impl.MapperContextImpl;
import com.google.appengine.tools.mapreduce.impl.WorkerShardTask;

public class MapShardTask<I, K, V>
extends WorkerShardTask<I, KeyValue<K, V>, MapperContext<K, V>> {
    private static final long serialVersionUID = 978040803132974582L;
    private final String mrJobId;
    private final int shardNumber;
    private final Mapper<I, K, V> mapper;
    private final OutputWriter<KeyValue<K, V>> out;

    public MapShardTask(String mrJobId, int shardNumber, int shardCount, InputReader<I> in, Mapper<I, K, V> mapper, OutputWriter<KeyValue<K, V>> out, long millisPerSlice) {
        super(mrJobId, shardNumber, shardCount, in, mapper, out, millisPerSlice, "mapper-calls", "mapper-walltime-msec");
        this.mrJobId = Preconditions.checkNotNull(mrJobId, "Null mrJobId");
        this.shardNumber = shardNumber;
        this.mapper = Preconditions.checkNotNull(mapper, "Null mapper");
        this.out = Preconditions.checkNotNull(out, "Null out");
    }

    @Override
    protected MapperContext<K, V> getWorkerContext(Counters counters) {
        return new MapperContextImpl<K, V>(this.mrJobId, this.out, this.shardNumber, counters);
    }

    @Override
    protected void callWorker(I input, MapperContext<K, V> context) {
        this.mapper.map(input, context);
    }

    @Override
    protected String formatLastWorkItem(I item) {
        return MapShardTask.abbrev(item);
    }
}

