/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl;

import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.tools.mapreduce.Counters;
import com.google.appengine.tools.mapreduce.KeyValue;
import com.google.appengine.tools.mapreduce.MapperContext;
import com.google.appengine.tools.mapreduce.OutputWriter;
import java.io.IOException;

class MapperContextImpl<K, V>
extends MapperContext<K, V> {
    private final String mrJobId;
    private final OutputWriter<KeyValue<K, V>> output;
    private final int shardNumber;
    private final Counters counters;

    MapperContextImpl(String mrJobId, OutputWriter<KeyValue<K, V>> output, int shardNumber, Counters counters) {
        this.mrJobId = Preconditions.checkNotNull(mrJobId, "Null mrJobId");
        this.output = Preconditions.checkNotNull(output, "Null output");
        this.shardNumber = shardNumber;
        this.counters = Preconditions.checkNotNull(counters, "Null counters");
    }

    @Override
    public void emit(K key, V value) {
        try {
            this.output.write(KeyValue.of(key, value));
        }
        catch (IOException e) {
            throw new RuntimeException(this.output + ".write(" + key + ", " + value + ") threw IOException", e);
        }
    }

    @Override
    public int getShardNumber() {
        return this.shardNumber;
    }

    @Override
    public Counters getCounters() {
        return this.counters;
    }

    @Override
    public String getJobId() {
        return this.mrJobId;
    }
}

