/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl;

import com.google.appengine.api.files.Crc32c;
import com.google.appengine.api.files.FileReadChannel;
import com.google.appengine.api.files.RecordReadChannel;
import com.google.appengine.tools.mapreduce.impl.RecordConstants;
import com.google.appengine.tools.mapreduce.impl.RecordType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;

public final class NonSpammingRecordReadChannel
implements RecordReadChannel {
    private Logger log = Logger.getLogger(NonSpammingRecordReadChannel.class.getName());
    private final FileReadChannel input;
    private ByteBuffer blockBuffer;
    private ByteBuffer finalRecord;

    public NonSpammingRecordReadChannel(FileReadChannel input) {
        this.input = input;
        this.blockBuffer = ByteBuffer.allocate(32768);
        this.blockBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.finalRecord = ByteBuffer.allocate(32768);
        this.finalRecord.order(ByteOrder.LITTLE_ENDIAN);
    }

    public ByteBuffer readRecord() throws IOException {
        this.finalRecord.clear();
        RecordType lastRead = RecordType.NONE;
        while (true) {
            try {
                while (true) {
                    Record record;
                    if ((record = this.readPhysicalRecord()) == null) {
                        return null;
                    }
                    switch (record.type()) {
                        case NONE: {
                            this.sync();
                            break;
                        }
                        case FULL: {
                            if (lastRead != RecordType.NONE) {
                                throw new RecordReadException("Invalid RecordType: " + (Object)((Object)record.type));
                            }
                            return record.data().slice();
                        }
                        case FIRST: {
                            if (lastRead != RecordType.NONE) {
                                throw new RecordReadException("Invalid RecordType: " + (Object)((Object)record.type));
                            }
                            this.finalRecord = NonSpammingRecordReadChannel.appendToBuffer(this.finalRecord, record.data());
                            break;
                        }
                        case MIDDLE: {
                            if (lastRead == RecordType.NONE) {
                                throw new RecordReadException("Invalid RecordType: " + (Object)((Object)record.type));
                            }
                            this.finalRecord = NonSpammingRecordReadChannel.appendToBuffer(this.finalRecord, record.data());
                            break;
                        }
                        case LAST: {
                            if (lastRead == RecordType.NONE) {
                                throw new RecordReadException("Invalid RecordType: " + (Object)((Object)record.type));
                            }
                            this.finalRecord = NonSpammingRecordReadChannel.appendToBuffer(this.finalRecord, record.data());
                            this.finalRecord.flip();
                            return this.finalRecord.slice();
                        }
                        default: {
                            throw new RecordReadException("Invalid RecordType: " + record.type.value());
                        }
                    }
                    lastRead = record.type();
                }
            }
            catch (RecordReadException e) {
                this.finalRecord.clear();
                this.sync();
                continue;
            }
            break;
        }
    }

    public long position() throws IOException {
        return this.input.position();
    }

    public void position(long newPosition) throws IOException {
        this.input.position(newPosition);
    }

    private Record readPhysicalRecord() throws IOException, RecordReadException {
        int bytesToBlockEnd = (int)(32768L - this.input.position() % 32768L);
        if (bytesToBlockEnd < 7) {
            return new Record(RecordType.NONE, null);
        }
        this.blockBuffer.clear();
        this.blockBuffer.limit(7);
        int bytesRead = this.input.read(this.blockBuffer);
        if (bytesRead != 7) {
            return null;
        }
        this.blockBuffer.flip();
        int checksum = this.blockBuffer.getInt();
        short length = this.blockBuffer.getShort();
        RecordType type = RecordType.get(this.blockBuffer.get());
        if (length > bytesToBlockEnd || length < 0) {
            throw new RecordReadException("Length is too large:" + length);
        }
        this.blockBuffer.clear();
        this.blockBuffer.limit(length);
        bytesRead = this.input.read(this.blockBuffer);
        if (bytesRead != length) {
            return null;
        }
        if (!NonSpammingRecordReadChannel.isValidCrc(checksum, this.blockBuffer, type.value())) {
            throw new RecordReadException("Checksum doesn't validate.");
        }
        this.blockBuffer.flip();
        return new Record(type, this.blockBuffer);
    }

    private void sync() throws IOException {
        long padLength = 32768L - this.input.position() % 32768L;
        this.input.position(this.input.position() + padLength);
    }

    private static boolean isValidCrc(int checksum, ByteBuffer data, byte type) {
        Crc32c crc = new Crc32c();
        crc.update((int)type);
        crc.update(data.array(), 0, data.limit());
        return RecordConstants.unmaskCrc(checksum) == crc.getValue();
    }

    private static ByteBuffer appendToBuffer(ByteBuffer to, ByteBuffer from) {
        if (to.remaining() < from.remaining()) {
            int capacity = to.capacity();
            while (capacity - to.position() < from.remaining()) {
                capacity *= 2;
            }
            ByteBuffer newBuffer = ByteBuffer.allocate(capacity);
            to.flip();
            newBuffer.put(to);
            to = newBuffer;
            to.order(ByteOrder.LITTLE_ENDIAN);
        }
        to.put(from);
        return to;
    }

    private static final class Record {
        private final ByteBuffer data;
        private final RecordType type;

        public Record(RecordType type, ByteBuffer data) {
            this.type = type;
            this.data = data;
        }

        public ByteBuffer data() {
            return this.data;
        }

        public RecordType type() {
            return this.type;
        }
    }

    static final class RecordReadException
    extends Exception {
        public RecordReadException(String errorMessage) {
            super(errorMessage);
        }
    }
}

