/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl;

import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.tools.mapreduce.Counters;
import com.google.appengine.tools.mapreduce.InputReader;
import com.google.appengine.tools.mapreduce.KeyValue;
import com.google.appengine.tools.mapreduce.OutputWriter;
import com.google.appengine.tools.mapreduce.Reducer;
import com.google.appengine.tools.mapreduce.ReducerContext;
import com.google.appengine.tools.mapreduce.ReducerInput;
import com.google.appengine.tools.mapreduce.impl.ReducerContextImpl;
import com.google.appengine.tools.mapreduce.impl.WorkerShardTask;

public class ReduceShardTask<K, V, O>
extends WorkerShardTask<KeyValue<K, ReducerInput<V>>, O, ReducerContext<O>> {
    private static final long serialVersionUID = 874429568286446321L;
    private final String mrJobId;
    private final int shardNumber;
    private final Reducer<K, V, O> reducer;
    private final OutputWriter<O> out;

    public ReduceShardTask(String mrJobId, int shardNumber, int shardCount, InputReader<KeyValue<K, ReducerInput<V>>> in, Reducer<K, V, O> reducer, OutputWriter<O> out, long millisPerSlice) {
        super(mrJobId, shardNumber, shardCount, in, reducer, out, millisPerSlice, "reducer-calls", "reducer-walltime-msec");
        this.mrJobId = Preconditions.checkNotNull(mrJobId, "Null mrJobId");
        this.shardNumber = shardNumber;
        this.reducer = Preconditions.checkNotNull(reducer, "Null reducer");
        this.out = Preconditions.checkNotNull(out, "Null out");
    }

    @Override
    protected ReducerContext<O> getWorkerContext(Counters counters) {
        return new ReducerContextImpl<O>(this.mrJobId, this.shardNumber, this.out, counters);
    }

    @Override
    protected void callWorker(KeyValue<K, ReducerInput<V>> input, ReducerContext<O> context) {
        this.reducer.reduce(input.getKey(), input.getValue(), context);
    }

    @Override
    protected String formatLastWorkItem(KeyValue<K, ReducerInput<V>> item) {
        return item == null ? null : ReduceShardTask.abbrev(item.getKey());
    }
}

