/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl;

import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.tools.mapreduce.Counters;
import com.google.appengine.tools.mapreduce.OutputWriter;
import com.google.appengine.tools.mapreduce.ReducerContext;
import java.io.IOException;

public class ReducerContextImpl<O>
extends ReducerContext<O> {
    private final String mrJobId;
    private final int shardNumber;
    private final OutputWriter<O> output;
    private final Counters counters;

    public ReducerContextImpl(String mrJobId, int shardNumber, OutputWriter<O> output, Counters counters) {
        this.mrJobId = Preconditions.checkNotNull(mrJobId, "Null mrJobId");
        this.shardNumber = shardNumber;
        this.output = Preconditions.checkNotNull(output, "Null output");
        this.counters = Preconditions.checkNotNull(counters, "Null counters");
    }

    @Override
    public void emit(O value) {
        try {
            this.output.write(value);
        }
        catch (IOException e) {
            throw new RuntimeException(this.output + ".write(" + value + ") threw IOException", e);
        }
    }

    @Override
    public int getShardNumber() {
        return this.shardNumber;
    }

    @Override
    public Counters getCounters() {
        return this.counters;
    }

    @Override
    public String getJobId() {
        return this.mrJobId;
    }
}

