/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl;

import com.google.appengine.tools.mapreduce.ReducerInput;
import java.util.Iterator;

public class ReducerInputs {
    private ReducerInputs() {
    }

    public static <V> ReducerInput<V> fromIterator(Iterator<V> i) {
        return new IteratorReducerInput<V>(i);
    }

    public static <V> ReducerInput<V> fromIterable(final Iterable<V> x) {
        return new IteratorReducerInput<V>(x.iterator()){

            @Override
            public String toString() {
                return "ReducerInputs.fromIterable(" + x + ")";
            }
        };
    }

    private static class IteratorReducerInput<V>
    extends ReducerInput<V> {
        private final Iterator<V> i;

        public IteratorReducerInput(Iterator<V> i) {
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public V next() {
            return this.i.next();
        }

        public String toString() {
            return "ReducerInputs.fromIterator(" + this.i + ")";
        }
    }
}

