/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl;

import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileServicePb;
import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.tools.mapreduce.impl.util.SerializationUtil;
import com.google.apphosting.api.ApiProxy;
import java.util.List;
import java.util.logging.Logger;

public class ShuffleService {
    private static final Logger log = Logger.getLogger(ShuffleService.class.getName());

    public void shuffle(String shuffleId, List<AppEngineFile> inputFiles, List<AppEngineFile> outputFiles, ShuffleCallback callback) {
        FileServicePb.ShuffleRequest.Builder request = FileServicePb.ShuffleRequest.newBuilder().setShuffleName(shuffleId);
        for (AppEngineFile inputFile : inputFiles) {
            Preconditions.checkArgument(inputFile.isReadable(), "Not readable: %s", inputFile);
            request.addInput(FileServicePb.ShuffleInputSpecification.newBuilder().setPath(inputFile.getFullPath()).setFormat(FileServicePb.ShuffleEnums.InputFormat.RECORDS_KEY_VALUE_PROTO_INPUT).build());
        }
        FileServicePb.ShuffleOutputSpecification.Builder output = FileServicePb.ShuffleOutputSpecification.newBuilder();
        output.setFormat(FileServicePb.ShuffleEnums.OutputFormat.RECORDS_KEY_MULTI_VALUE_PROTO_OUTPUT);
        for (AppEngineFile outputFile : outputFiles) {
            Preconditions.checkArgument(outputFile.isWritable(), "Not writable: %s", outputFile);
            output.addPath(outputFile.getFullPath());
        }
        request.setOutput(output.build());
        request.setShuffleSizeBytes(0L);
        FileServicePb.ShuffleRequest.Callback.Builder callbackProto = FileServicePb.ShuffleRequest.Callback.newBuilder().setUrl(callback.getUrl()).setMethod(callback.getMethod());
        if (callback.getAppVersionId() != null) {
            callbackProto.setAppVersionId(callback.getAppVersionId());
        } else {
            callbackProto.setAppVersionId(ApiProxy.getCurrentEnvironment().getVersionId());
        }
        log.info("versionId: " + ApiProxy.getCurrentEnvironment().getVersionId());
        if (callback.getQueue() != null) {
            callbackProto.setQueue(callback.getQueue());
        }
        request.setCallback(callbackProto.build());
        log.info("Starting shuffle job " + shuffleId + " with callback " + callback + ": " + request.build());
        if (!this.isAvailable()) {
            throw new RuntimeException("not available");
        }
        ApiProxy.ApiConfig config = new ApiProxy.ApiConfig();
        config.setDeadlineInSeconds(Double.valueOf(30.0));
        byte[] response = ApiProxy.makeSyncCall((String)"file", (String)"Shuffle", (byte[])request.build().toByteArray(), (ApiProxy.ApiConfig)config);
    }

    public boolean isAvailable() {
        FileServicePb.GetCapabilitiesResponse response;
        byte[] responseBytes = ApiProxy.makeSyncCall((String)"file", (String)"GetCapabilities", (byte[])FileServicePb.GetCapabilitiesRequest.newBuilder().build().toByteArray());
        try {
            response = FileServicePb.GetCapabilitiesResponse.parseFrom((byte[])responseBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Failed to parse GetCapabilitiesResponse: " + SerializationUtil.prettyBytes(responseBytes), e);
        }
        return response.getShuffleAvailable();
    }

    public FileServicePb.GetShuffleStatusResponse getStatus(String shuffleId) {
        FileServicePb.GetShuffleStatusResponse response;
        byte[] responseBytes = ApiProxy.makeSyncCall((String)"file", (String)"GetShuffleStatus", (byte[])FileServicePb.GetShuffleStatusRequest.newBuilder().setShuffleName(shuffleId).build().toByteArray());
        try {
            response = FileServicePb.GetShuffleStatusResponse.parseFrom((byte[])responseBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Failed to parse GetShuffleStatusResponse: " + SerializationUtil.prettyBytes(responseBytes), e);
        }
        return response;
    }

    public static final class ShuffleCallback {
        private final String url;
        private String appVersionId = null;
        private String queue = null;
        private String method = "GET";

        public ShuffleCallback(String url) {
            this.url = Preconditions.checkNotNull(url, "Null url");
        }

        public String getUrl() {
            return this.url;
        }

        public String getAppVersionId() {
            return this.appVersionId;
        }

        public ShuffleCallback setAppVersionId(String appVersionId) {
            this.appVersionId = appVersionId;
            return this;
        }

        public String getQueue() {
            return this.queue;
        }

        public ShuffleCallback setQueue(String queue) {
            this.queue = queue;
            return this;
        }

        public String getMethod() {
            return this.method;
        }

        public ShuffleCallback setMethod(String method) {
            this.method = Preconditions.checkNotNull(method, "Null method");
            return this;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.url + ", " + this.appVersionId + ", " + this.queue + ", " + this.method + ")";
        }
    }
}

