/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl.handlers;

import com.google.appengine.tools.mapreduce.MapReduceServlet;
import com.google.appengine.tools.mapreduce.impl.handlers.StatusHandler;
import com.google.appengine.tools.mapreduce.impl.shardedjob.ShardedJobServiceFactory;
import com.google.appengine.tools.pipeline.NoSuchObjectException;
import com.google.appengine.tools.pipeline.OrphanedObjectException;
import com.google.appengine.tools.pipeline.PipelineServiceFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class MapReduceServletImpl {
    public static final Logger LOG = Logger.getLogger(MapReduceServlet.class.getName());
    public static final String CONTROLLER_PATH = "controllerCallback";
    public static final String WORKER_PATH = "workerCallback";
    public static final String SHUFFLE_CALLBACK_PATH = "shuffleCallback";
    static final String COMMAND_PATH = "command";

    private MapReduceServletImpl() {
    }

    public static void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String handler = MapReduceServletImpl.getHandler(request);
        if (handler.startsWith(COMMAND_PATH)) {
            if (!MapReduceServletImpl.checkForAjax(request, response)) {
                return;
            }
            StatusHandler.handleCommand(handler.substring(COMMAND_PATH.length() + 1), request, response);
        } else if (handler.startsWith(SHUFFLE_CALLBACK_PATH)) {
            if (!MapReduceServletImpl.checkForTaskQueue(request, response)) {
                return;
            }
            MapReduceServletImpl.handleShuffleCallback(request);
        } else {
            MapReduceServletImpl.handleStaticResources(handler, response);
        }
    }

    public static void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String handler = MapReduceServletImpl.getHandler(request);
        if (handler.startsWith(CONTROLLER_PATH)) {
            if (!MapReduceServletImpl.checkForTaskQueue(request, response)) {
                return;
            }
            ShardedJobServiceFactory.getShardedJobService().handleControllerRequest(request);
        } else if (handler.startsWith(WORKER_PATH)) {
            if (!MapReduceServletImpl.checkForTaskQueue(request, response)) {
                return;
            }
            ShardedJobServiceFactory.getShardedJobService().handleWorkerRequest(request);
        } else if (handler.startsWith(COMMAND_PATH)) {
            if (!MapReduceServletImpl.checkForAjax(request, response)) {
                return;
            }
            StatusHandler.handleCommand(handler.substring(COMMAND_PATH.length() + 1), request, response);
        } else if (handler.startsWith(SHUFFLE_CALLBACK_PATH)) {
            if (!MapReduceServletImpl.checkForTaskQueue(request, response)) {
                return;
            }
            MapReduceServletImpl.handleShuffleCallback(request);
        } else {
            throw new RuntimeException("Received an unknown MapReduce request handler. See logs for more detail.");
        }
    }

    private static void handleShuffleCallback(HttpServletRequest request) throws IOException {
        String promiseHandle = request.getParameter("promiseHandle");
        String errorCode = request.getParameter("error");
        LOG.info("shuffle callback; promiseHandle=" + promiseHandle + ", error=" + errorCode);
        try {
            PipelineServiceFactory.newPipelineService().submitPromisedValue(promiseHandle, errorCode);
        }
        catch (NoSuchObjectException e) {
            throw new RuntimeException("NoSuchObjectException for promiseHandle " + promiseHandle, e);
        }
        catch (OrphanedObjectException e) {
            LOG.log(Level.WARNING, "OrphanedObjectException for promiseHandle " + promiseHandle, e);
        }
    }

    private static boolean checkForAjax(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!"XMLHttpRequest".equals(request.getHeader("X-Requested-With"))) {
            LOG.log(Level.SEVERE, "Received unexpected non-XMLHttpRequest command. Possible CSRF attack.");
            response.sendError(403, "Received unexpected non-XMLHttpRequest command.");
            return false;
        }
        return true;
    }

    private static boolean checkForTaskQueue(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getHeader("X-AppEngine-QueueName") == null) {
            LOG.log(Level.SEVERE, "Received unexpected non-task queue request. Possible CSRF attack.");
            response.sendError(403, "Received unexpected non-task queue request.");
            return false;
        }
        return true;
    }

    static String getBase(HttpServletRequest request) {
        String fullPath = request.getRequestURI();
        int baseEnd = MapReduceServletImpl.getDividingIndex(fullPath);
        return fullPath.substring(0, baseEnd + 1);
    }

    private static int getDividingIndex(String fullPath) {
        int baseEnd = fullPath.lastIndexOf(47);
        if (fullPath.substring(0, baseEnd).endsWith(COMMAND_PATH)) {
            baseEnd = fullPath.substring(0, baseEnd).lastIndexOf(47);
        }
        return baseEnd;
    }

    static String getHandler(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        return requestURI.substring(MapReduceServletImpl.getDividingIndex(requestURI) + 1);
    }

    static void handleStaticResources(String handler, HttpServletResponse response) throws IOException {
        String fileName;
        if (handler.equals("status")) {
            response.setContentType("text/html");
            fileName = "overview.html";
        } else if (handler.equals("detail")) {
            response.setContentType("text/html");
            fileName = "detail.html";
        } else if (handler.equals("base.css")) {
            response.setContentType("text/css");
            fileName = "base.css";
        } else if (handler.equals("jquery.js")) {
            response.setContentType("text/javascript");
            fileName = "jquery-1.6.1.min.js";
        } else if (handler.equals("jquery-json.js")) {
            response.setContentType("text/javascript");
            fileName = "jquery.json-2.2.min.js";
        } else if (handler.equals("status.js")) {
            response.setContentType("text/javascript");
            fileName = "status.js";
        } else {
            response.sendError(404);
            return;
        }
        response.setHeader("Cache-Control", "public; max-age=300");
        try {
            int bytesRead;
            InputStream resourceStream = MapReduceServlet.class.getResourceAsStream("/com/google/appengine/tools/mapreduce/" + fileName);
            if (resourceStream == null) {
                resourceStream = MapReduceServlet.class.getResourceAsStream("/third_party/java_src/appengine_mapreduce2/static/" + fileName);
            }
            if (resourceStream == null) {
                throw new RuntimeException("Couldn't find static file for MapReduce library: " + fileName);
            }
            ServletOutputStream responseStream = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = resourceStream.read(buffer)) >= 0) {
                responseStream.write(buffer, 0, bytesRead);
            }
            responseStream.flush();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Couldn't find static file for MapReduce library", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read static file for MapReduce library", e);
        }
    }
}

