/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl.handlers;

import com.google.appengine.labs.repackaged.com.google.common.collect.Lists;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.AxisLabelsFactory;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.BarChart;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.BarChartPlot;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Data;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.DataUtil;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.GCharts;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Plot;
import com.google.appengine.labs.repackaged.com.googlecode.charts4j.Plots;
import com.google.appengine.labs.repackaged.org.json.JSONArray;
import com.google.appengine.labs.repackaged.org.json.JSONException;
import com.google.appengine.labs.repackaged.org.json.JSONObject;
import com.google.appengine.tools.mapreduce.Counter;
import com.google.appengine.tools.mapreduce.Counters;
import com.google.appengine.tools.mapreduce.impl.AbstractWorkerController;
import com.google.appengine.tools.mapreduce.impl.WorkerResult;
import com.google.appengine.tools.mapreduce.impl.WorkerShardState;
import com.google.appengine.tools.mapreduce.impl.handlers.MapReduceServletImpl;
import com.google.appengine.tools.mapreduce.impl.shardedjob.ShardedJobServiceFactory;
import com.google.appengine.tools.mapreduce.impl.shardedjob.ShardedJobState;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

final class StatusHandler {
    public static final int DEFAULT_JOBS_PER_PAGE_COUNT = 50;
    public static final String LIST_JOBS_PATH = "list_jobs";
    public static final String LIST_CONFIGS_PATH = "list_configs";
    public static final String CLEANUP_JOB_PATH = "cleanup_job";
    public static final String ABORT_JOB_PATH = "abort_job";
    public static final String GET_JOB_DETAIL_PATH = "get_job_detail";
    public static final String START_JOB_PATH = "start_job";

    private StatusHandler() {
    }

    private static JSONObject handleCleanupJob(String jobId) throws JSONException {
        JSONObject retValue = new JSONObject();
        ShardedJobServiceFactory.getShardedJobService().cleanupJob(jobId);
        retValue.put("status", "Successfully deleted requested job.");
        return retValue;
    }

    private static JSONObject handleAbortJob(String jobId) throws JSONException {
        JSONObject retValue = new JSONObject();
        ShardedJobServiceFactory.getShardedJobService().abortJob(jobId);
        retValue.put("status", "Successfully aborted requested job.");
        return retValue;
    }

    static void handleCommand(String command, HttpServletRequest request, HttpServletResponse response) {
        JSONObject retValue;
        block13: {
            response.setContentType("application/json");
            boolean isPost = "POST".equals(request.getMethod());
            try {
                if (command.equals(LIST_CONFIGS_PATH) && !isPost) {
                    retValue = StatusHandler.handleListConfigs();
                    break block13;
                }
                if (command.equals(LIST_JOBS_PATH) && !isPost) {
                    retValue = StatusHandler.handleListJobs(request);
                    break block13;
                }
                if (command.equals(CLEANUP_JOB_PATH) && isPost) {
                    retValue = StatusHandler.handleCleanupJob(request.getParameter("mapreduce_id"));
                    break block13;
                }
                if (command.equals(ABORT_JOB_PATH) && isPost) {
                    retValue = StatusHandler.handleAbortJob(request.getParameter("mapreduce_id"));
                    break block13;
                }
                if (command.equals(GET_JOB_DETAIL_PATH) && !isPost) {
                    retValue = StatusHandler.handleGetJobDetail(request.getParameter("mapreduce_id"));
                    break block13;
                }
                if (command.equals(START_JOB_PATH) && isPost) {
                    retValue = StatusHandler.handleStartJob();
                    break block13;
                }
                response.sendError(404);
                return;
            }
            catch (Throwable t) {
                MapReduceServletImpl.LOG.log(Level.SEVERE, "Got exception while running command", t);
                try {
                    retValue = new JSONObject();
                    retValue.put("error_class", t.getClass().getName());
                    retValue.put("error_message", "Full stack trace is available in the server logs. Message: " + t.getMessage());
                }
                catch (JSONException e) {
                    throw new RuntimeException("Couldn't create error JSON object", e);
                }
            }
        }
        try {
            retValue.write(response.getWriter());
            response.getWriter().flush();
        }
        catch (JSONException e) {
            throw new RuntimeException("Couldn't write command response", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't write command response", e);
        }
    }

    private static JSONObject toJson(Counters counters) throws JSONException {
        JSONObject retValue = new JSONObject();
        for (Counter counter : counters.getCounters()) {
            retValue.put(counter.getName(), counter.getValue());
        }
        return retValue;
    }

    private static String getChartUrl(int shardCount, Map<Integer, WorkerShardState> workerShardStates) {
        ArrayList<Long> processedCounts = Lists.newArrayListWithCapacity(workerShardStates.size());
        for (int i = 0; i < shardCount; ++i) {
            processedCounts.add(workerShardStates.get(i) == null ? 0L : workerShardStates.get(i).getWorkerCallCount());
        }
        long maxPlusOne = processedCounts.isEmpty() ? 1L : (Long)Collections.max(processedCounts) + 1L;
        ArrayList<String> countLabels = new ArrayList<String>();
        for (int i = 0; i < processedCounts.size(); ++i) {
            countLabels.add(String.valueOf(i));
        }
        Data countData = DataUtil.scaleWithinRange(0.0, (double)maxPlusOne, processedCounts);
        BarChartPlot countPlot = Plots.newBarChartPlot(countData);
        BarChart countChart = GCharts.newBarChart(new Plot[]{countPlot});
        countChart.addYAxisLabels(AxisLabelsFactory.newNumericRangeAxisLabels(0.0, maxPlusOne));
        countChart.addXAxisLabels(AxisLabelsFactory.newAxisLabels(countLabels));
        countChart.setSize(300, 200);
        countChart.setBarWidth(0);
        countChart.setSpaceBetweenGroupsOfBars(1);
        return countChart.toURLString();
    }

    private static JSONObject handleGetJobDetail(String jobId) {
        ShardedJobState<?, Serializable> state = ShardedJobServiceFactory.getShardedJobService().getJobState(jobId);
        AbstractWorkerController controller = (AbstractWorkerController)state.getController();
        JSONObject jobObject = new JSONObject();
        try {
            jobObject.put("name", controller.getShardedJobName());
            jobObject.put("mapreduce_id", jobId);
            jobObject.put("updated_timestamp_ms", state.getMostRecentUpdateTimeMillis());
            jobObject.put("start_timestamp_ms", state.getStartTimeMillis());
            if (state.getStatus().isActive()) {
                jobObject.put("active", true);
            } else {
                jobObject.put("active", false);
                jobObject.put("result_status", "" + (Object)((Object)state.getStatus()));
            }
            jobObject.put("shards", state.getTotalTaskCount());
            jobObject.put("active_shards", state.getActiveTaskCount());
            jobObject.put("counters", StatusHandler.toJson(((WorkerResult)state.getAggregateResult()).getCounters()));
            jobObject.put("chart_url", StatusHandler.getChartUrl(state.getTotalTaskCount(), ((WorkerResult)state.getAggregateResult()).getWorkerShardStates()));
            JSONObject mapperParams = new JSONObject();
            mapperParams.put("Shards completed", state.getTotalTaskCount() - state.getActiveTaskCount());
            mapperParams.put("Shards active", state.getActiveTaskCount());
            mapperParams.put("Shards total", state.getTotalTaskCount());
            JSONObject mapperSpec = new JSONObject();
            mapperSpec.put("mapper_params", mapperParams);
            jobObject.put("mapper_spec", mapperSpec);
            JSONArray shardArray = new JSONArray();
            for (int i = 0; i < state.getTotalTaskCount(); ++i) {
                WorkerShardState shard = ((WorkerResult)state.getAggregateResult()).getWorkerShardStates().get(i);
                JSONObject shardObject = new JSONObject();
                shardObject.put("shard_number", i);
                if (shard == null) {
                    shardObject.put("active", false);
                    shardObject.put("result_status", "initializing");
                    shardObject.put("shard_description", "");
                } else {
                    boolean done;
                    boolean bl = done = ((WorkerResult)state.getAggregateResult()).getClosedWriters().get(i) != null;
                    if (done) {
                        shardObject.put("active", false);
                        shardObject.put("result_status", "done");
                    } else {
                        shardObject.put("active", true);
                    }
                    shardObject.put("shard_description", "");
                    shardObject.put("updated_timestamp_ms", shard.getMostRecentUpdateTimeMillis());
                    shardObject.put("last_work_item", shard.getLastWorkItem());
                }
                shardArray.put(shardObject);
            }
            jobObject.put("shards", shardArray);
        }
        catch (JSONException e) {
            throw new RuntimeException("Hard coded string is null", e);
        }
        return jobObject;
    }

    private static JSONObject handleListConfigs() {
        return new JSONObject();
    }

    private static JSONObject handleListJobs(HttpServletRequest request) throws JSONException {
        String cursor = request.getParameter("cursor");
        String countString = request.getParameter("count");
        int count = 50;
        if (countString != null) {
            count = Integer.parseInt(countString);
        }
        return StatusHandler.handleListJobs(cursor, count);
    }

    private static JSONObject handleListJobs(String cursor, int count) throws JSONException {
        throw new RuntimeException("Not implemented");
    }

    private static JSONObject handleStartJob() {
        throw new UnsupportedOperationException("handleStartJob is not implemented.");
    }
}

