/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl.shardedjob;

import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.labs.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.tools.mapreduce.impl.shardedjob.IncrementalTask;
import com.google.appengine.tools.mapreduce.impl.shardedjob.ShardedJobController;
import java.io.Serializable;
import java.util.List;

public class InProcessShardedJobRunner {
    private InProcessShardedJobRunner() {
    }

    public static <T extends IncrementalTask<T, R>, R extends Serializable> R runJob(List<? extends T> initialTasks, ShardedJobController<T, R> controller) {
        R partialResult = controller.combineResults(ImmutableList.of());
        for (IncrementalTask task : initialTasks) {
            IncrementalTask.RunResult runResult;
            Preconditions.checkNotNull(task, "Null initial task: %s", initialTasks);
            do {
                runResult = task.run();
                partialResult = controller.combineResults(ImmutableList.of(partialResult, runResult.getPartialResult()));
            } while ((task = runResult.getFollowupTask()) != null);
        }
        controller.completed(partialResult);
        return partialResult;
    }
}

