/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl.shardedjob;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.labs.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.tools.mapreduce.impl.shardedjob.IncrementalTask;
import com.google.appengine.tools.mapreduce.impl.util.SerializationUtil;
import java.io.Serializable;

class IncrementalTaskState<T extends IncrementalTask<T, R>, R extends Serializable> {
    private final String taskId;
    private final String jobId;
    private long mostRecentUpdateMillis;
    private int nextSequenceNumber = 0;
    private T nextTask;
    private R partialResult;

    public IncrementalTaskState(String taskId, String jobId, long mostRecentUpdateMillis, T initialTask, R initialPartialResult) {
        this.taskId = Preconditions.checkNotNull(taskId, "Null taskId");
        this.jobId = Preconditions.checkNotNull(jobId, "Null jobId");
        this.mostRecentUpdateMillis = mostRecentUpdateMillis;
        this.nextTask = initialTask;
        this.partialResult = initialPartialResult;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getMostRecentUpdateMillis() {
        return this.mostRecentUpdateMillis;
    }

    public IncrementalTaskState<T, R> setMostRecentUpdateMillis(long mostRecentUpdateMillis) {
        this.mostRecentUpdateMillis = mostRecentUpdateMillis;
        return this;
    }

    public int getNextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    public IncrementalTaskState<T, R> setNextSequenceNumber(int nextSequenceNumber) {
        this.nextSequenceNumber = nextSequenceNumber;
        return this;
    }

    public T getNextTask() {
        return this.nextTask;
    }

    public IncrementalTaskState<T, R> setNextTask(T nextTask) {
        this.nextTask = nextTask;
        return this;
    }

    public R getPartialResult() {
        return this.partialResult;
    }

    public IncrementalTaskState<T, R> setPartialResult(R partialResult) {
        this.partialResult = partialResult;
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.taskId + ", " + this.jobId + ", " + this.mostRecentUpdateMillis + ", " + this.nextSequenceNumber + ", " + this.nextTask + ", " + this.partialResult + ")";
    }

    static class Serializer {
        static final String ENTITY_KIND = "MR-IncrementalTask";
        private static final String JOB_ID_PROPERTY = "jobId";
        private static final String MOST_RECENT_UPDATE_MILLIS_PROPERTY = "mostRecentUpdateMillis";
        private static final String NEXT_SEQUENCE_NUMBER_PROPERTY = "sequenceNumber";
        private static final String NEXT_TASK_PROPERTY = "nextTask";
        private static final String PARTIAL_RESULT_PROPERTY = "partialResult";

        Serializer() {
        }

        static Key makeKey(String taskId) {
            return KeyFactory.createKey((String)ENTITY_KIND, (String)taskId);
        }

        static Entity toEntity(IncrementalTaskState in) {
            Entity out = new Entity(Serializer.makeKey(in.getTaskId()));
            out.setProperty(JOB_ID_PROPERTY, (Object)in.getJobId());
            out.setUnindexedProperty(MOST_RECENT_UPDATE_MILLIS_PROPERTY, (Object)in.getMostRecentUpdateMillis());
            out.setProperty(NEXT_SEQUENCE_NUMBER_PROPERTY, (Object)in.getNextSequenceNumber());
            if (in.getNextTask() != null) {
                out.setUnindexedProperty(NEXT_TASK_PROPERTY, (Object)new Blob(SerializationUtil.serializeToByteArray(in.getNextTask())));
            }
            if (in.getPartialResult() != null) {
                out.setUnindexedProperty(PARTIAL_RESULT_PROPERTY, (Object)new Blob(SerializationUtil.serializeToByteArray(in.getPartialResult())));
            }
            return out;
        }

        static <T extends IncrementalTask<T, R>, R extends Serializable> IncrementalTaskState<T, R> fromEntity(Entity in) {
            Preconditions.checkArgument(ENTITY_KIND.equals(in.getKind()), "Unexpected kind: %s", in);
            return new IncrementalTaskState<IncrementalTask, Object>(in.getKey().getName(), (String)in.getProperty(JOB_ID_PROPERTY), (Long)in.getProperty(MOST_RECENT_UPDATE_MILLIS_PROPERTY), in.hasProperty(NEXT_TASK_PROPERTY) ? (IncrementalTask)SerializationUtil.deserializeFromDatastorePropertyUnchecked(in, NEXT_TASK_PROPERTY) : null, (in.hasProperty(PARTIAL_RESULT_PROPERTY) ? SerializationUtil.deserializeFromDatastorePropertyUnchecked(in, PARTIAL_RESULT_PROPERTY) : null)).setNextSequenceNumber(Ints.checkedCast((Long)in.getProperty(NEXT_SEQUENCE_NUMBER_PROPERTY)));
        }
    }
}

