/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl.shardedjob;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.labs.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.tools.mapreduce.impl.shardedjob.IncrementalTask;
import com.google.appengine.tools.mapreduce.impl.shardedjob.ShardedJobController;
import com.google.appengine.tools.mapreduce.impl.shardedjob.ShardedJobSettings;
import com.google.appengine.tools.mapreduce.impl.shardedjob.ShardedJobState;
import com.google.appengine.tools.mapreduce.impl.shardedjob.Status;
import com.google.appengine.tools.mapreduce.impl.util.SerializationUtil;
import java.io.Serializable;

class ShardedJobStateImpl<T extends IncrementalTask<T, R>, R extends Serializable>
implements ShardedJobState<T, R> {
    private final String jobId;
    private final ShardedJobController<T, R> controller;
    private final ShardedJobSettings settings;
    private final int totalTaskCount;
    private final long startTimeMillis;
    private long mostRecentUpdateTimeMillis;
    private int nextSequenceNumber = 0;
    private int activeTaskCount;
    private Status status;
    private R aggregateResult;

    public ShardedJobStateImpl(String jobId, ShardedJobController<T, R> controller, ShardedJobSettings settings, int totalTaskCount, long startTimeMillis, Status status, R initialAggregateResult) {
        this.jobId = Preconditions.checkNotNull(jobId, "Null jobId");
        this.controller = Preconditions.checkNotNull(controller, "Null controller");
        this.settings = Preconditions.checkNotNull(settings, "Null settings");
        this.totalTaskCount = totalTaskCount;
        this.activeTaskCount = totalTaskCount;
        this.startTimeMillis = startTimeMillis;
        this.mostRecentUpdateTimeMillis = startTimeMillis;
        this.status = Preconditions.checkNotNull(status, "Null status");
        this.aggregateResult = initialAggregateResult;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public ShardedJobController<T, R> getController() {
        return this.controller;
    }

    @Override
    public ShardedJobSettings getSettings() {
        return this.settings;
    }

    @Override
    public int getTotalTaskCount() {
        return this.totalTaskCount;
    }

    @Override
    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    @Override
    public long getMostRecentUpdateTimeMillis() {
        return this.mostRecentUpdateTimeMillis;
    }

    ShardedJobStateImpl<T, R> setMostRecentUpdateTimeMillis(long mostRecentUpdateTimeMillis) {
        this.mostRecentUpdateTimeMillis = mostRecentUpdateTimeMillis;
        return this;
    }

    long getNextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    ShardedJobStateImpl<T, R> setNextSequenceNumber(int nextSequenceNumber) {
        this.nextSequenceNumber = nextSequenceNumber;
        return this;
    }

    @Override
    public int getActiveTaskCount() {
        return this.activeTaskCount;
    }

    ShardedJobStateImpl<T, R> setActiveTaskCount(int activeTaskCount) {
        this.activeTaskCount = activeTaskCount;
        return this;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    ShardedJobStateImpl<T, R> setStatus(Status status) {
        this.status = Preconditions.checkNotNull(status, "Null status");
        return this;
    }

    @Override
    public R getAggregateResult() {
        return this.aggregateResult;
    }

    ShardedJobStateImpl<T, R> setAggregateResult(R aggregateResult) {
        this.aggregateResult = aggregateResult;
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.controller + ", " + this.nextSequenceNumber + ", " + (Object)((Object)this.status) + ", " + this.activeTaskCount + "/" + this.totalTaskCount + ", " + this.mostRecentUpdateTimeMillis + ", " + this.aggregateResult + ")";
    }

    static class Serializer {
        static final String ENTITY_KIND = "MR-ShardedJob";
        private static final String CONTROLLER_PROPERTY = "controller";
        private static final String START_TIME_PROPERTY = "startTimeMillis";
        private static final String SETTINGS_PROPERTY = "settings";
        private static final String TOTAL_TASK_COUNT_PROPERTY = "taskCount";
        private static final String MOST_RECENT_UPDATE_TIME_PROPERTY = "mostRecentUpdateTimeMillis";
        private static final String NEXT_SEQUENCE_NUMBER_PROPERTY = "nextSequenceNumber";
        private static final String ACTIVE_TASK_COUNT_PROPERTY = "activeTaskCount";
        private static final String STATUS_PROPERTY = "status";
        private static final String AGGREGATE_RESULT_PROPERTY = "result";

        Serializer() {
        }

        static Key makeKey(String jobId) {
            return KeyFactory.createKey((String)ENTITY_KIND, (String)jobId);
        }

        static Entity toEntity(ShardedJobStateImpl<?, ?> in) {
            Entity out = new Entity(Serializer.makeKey(in.getJobId()));
            out.setUnindexedProperty(CONTROLLER_PROPERTY, (Object)new Blob(SerializationUtil.serializeToByteArray(in.getController())));
            out.setUnindexedProperty(SETTINGS_PROPERTY, (Object)new Blob(SerializationUtil.serializeToByteArray(in.getSettings())));
            out.setUnindexedProperty(TOTAL_TASK_COUNT_PROPERTY, (Object)in.getTotalTaskCount());
            out.setUnindexedProperty(START_TIME_PROPERTY, (Object)in.getStartTimeMillis());
            out.setUnindexedProperty(MOST_RECENT_UPDATE_TIME_PROPERTY, (Object)in.getMostRecentUpdateTimeMillis());
            out.setUnindexedProperty(NEXT_SEQUENCE_NUMBER_PROPERTY, (Object)in.getNextSequenceNumber());
            out.setUnindexedProperty(ACTIVE_TASK_COUNT_PROPERTY, (Object)in.getActiveTaskCount());
            out.setUnindexedProperty(STATUS_PROPERTY, (Object)("" + (Object)((Object)in.getStatus())));
            if (in.getAggregateResult() != null) {
                out.setUnindexedProperty(AGGREGATE_RESULT_PROPERTY, (Object)new Blob(SerializationUtil.serializeToByteArray(in.getAggregateResult())));
            }
            return out;
        }

        static <T extends IncrementalTask<T, R>, R extends Serializable> ShardedJobStateImpl<T, R> fromEntity(Entity in) {
            Preconditions.checkArgument(ENTITY_KIND.equals(in.getKind()), "Unexpected kind: %s", in);
            return new ShardedJobStateImpl(in.getKey().getName(), (ShardedJobController)SerializationUtil.deserializeFromDatastorePropertyUnchecked(in, CONTROLLER_PROPERTY), (ShardedJobSettings)SerializationUtil.deserializeFromDatastorePropertyUnchecked(in, SETTINGS_PROPERTY), Ints.checkedCast((Long)in.getProperty(TOTAL_TASK_COUNT_PROPERTY)), (Long)in.getProperty(START_TIME_PROPERTY), Status.valueOf((String)in.getProperty(STATUS_PROPERTY)), (in.hasProperty(AGGREGATE_RESULT_PROPERTY) ? SerializationUtil.deserializeFromDatastorePropertyUnchecked(in, AGGREGATE_RESULT_PROPERTY) : null)).setMostRecentUpdateTimeMillis((Long)in.getProperty(MOST_RECENT_UPDATE_TIME_PROPERTY)).setNextSequenceNumber(Ints.checkedCast((Long)in.getProperty(NEXT_SEQUENCE_NUMBER_PROPERTY))).setActiveTaskCount(Ints.checkedCast((Long)in.getProperty(ACTIVE_TASK_COUNT_PROPERTY)));
        }
    }
}

