/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl.util;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileService;
import com.google.appengine.api.files.FileServiceFactory;
import com.google.appengine.api.files.FileWriteChannel;
import com.google.appengine.api.files.FinalizationException;
import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.tools.mapreduce.impl.util.RetryHelper;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUtil {
    private static final Logger log = Logger.getLogger(FileUtil.class.getName());
    private static final FileService FILE_SERVICE = FileServiceFactory.getFileService();

    private FileUtil() {
    }

    public static boolean isErrorCode(IOException e, int code) {
        return e.getCause() != null && e.getCause() instanceof ApiProxy.ApplicationException && ((ApiProxy.ApplicationException)e.getCause()).getApplicationError() == code;
    }

    public static void tryClosingOnce(FileWriteChannel c) throws IOException {
        if (c.isOpen()) {
            try {
                c.close();
            }
            catch (IOException e) {
                if (FileUtil.isErrorCode(e, 10)) {
                    log.log(Level.INFO, "File " + c + " already closed, ignoring exception: " + RetryHelper.messageChain(e));
                    return;
                }
                log.log(Level.INFO, "Got IOException closing " + c, e);
                throw e;
            }
        }
    }

    public static BlobKey getBlobKey(final AppEngineFile finalizedBlobFile) {
        return RetryHelper.runWithRetries(new RetryHelper.Body<BlobKey>(){

            public String toString() {
                return "get BlobKey for " + finalizedBlobFile;
            }

            @Override
            public BlobKey run() throws IOException {
                BlobKey key = FILE_SERVICE.getBlobKey(finalizedBlobFile);
                if (key == null) {
                    throw new IOException(this + ": getBlobKey() returned null");
                }
                return key;
            }
        });
    }

    public static AppEngineFile getReadHandle(AppEngineFile file) {
        if (file.getFileSystem() == AppEngineFile.FileSystem.BLOBSTORE) {
            return new AppEngineFile(file.getFileSystem(), FileUtil.getBlobKey(file).getKeyString());
        }
        return file;
    }

    public static AppEngineFile ensureFinalized(final AppEngineFile file) {
        return RetryHelper.runWithRetries(new RetryHelper.Body<AppEngineFile>(){
            String stage = "init";
            FileWriteChannel out = null;

            public String toString() {
                return "finalizing file " + file;
            }

            @Override
            public AppEngineFile run() throws IOException {
                boolean alreadyFinalized;
                if (this.out != null) {
                    this.stage = "close previous";
                    FileUtil.tryClosingOnce(this.out);
                    this.out = null;
                }
                this.stage = "acquire lock";
                try {
                    this.out = FILE_SERVICE.openWriteChannel(file, true);
                    alreadyFinalized = false;
                }
                catch (FinalizationException e) {
                    log.info(this + ": File already finalized, ignoring exception: " + RetryHelper.messageChain(e));
                    alreadyFinalized = true;
                }
                catch (IOException e) {
                    if (FileUtil.isErrorCode(e, 101)) {
                        log.info(this + ": File already finalized, ignoring exception: " + RetryHelper.messageChain(e));
                        alreadyFinalized = true;
                    }
                    throw e;
                }
                if (!alreadyFinalized) {
                    this.stage = "close and finalize";
                    this.out.closeFinally();
                } else {
                    Preconditions.checkState(this.out == null, "%s: %s", this, this.out);
                }
                return FileUtil.getReadHandle(file);
            }
        });
    }
}

