/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl.util;

import com.google.appengine.labs.repackaged.com.google.common.base.Stopwatch;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.logging.Logger;

public class RetryHelper<V> {
    private static final Logger log = Logger.getLogger(RetryHelper.class.getName());
    private static final int RETRY_MIN_ATTEMPTS = 5;
    private static final int RETRY_MAX_ATTEMPTS = 200;
    private static final long INITIAL_RETRY_DELAY_MILLIS = 10L;
    private static final long MAX_RETRY_DELAY_MILLIS = 10000L;
    private static final double RETRY_DELAY_BACKOFF_FACTOR = 2.0;
    private static final long RETRY_PERIOD_MILLIS = 240000L;
    private final Stopwatch stopwatch = new Stopwatch();
    private int attemptsSoFar = 0;
    private final Body<V> body;

    public static String messageChain(Throwable t) {
        StringBuilder b = new StringBuilder("" + t);
        for (t = t.getCause(); t != null; t = t.getCause()) {
            b.append("\n -- caused by: " + t);
        }
        return "" + b;
    }

    private RetryHelper(Body<V> body) {
        this.body = body;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.stopwatch + ", " + this.attemptsSoFar + " attempts, " + this.body + ")";
    }

    private V doRetry() {
        this.stopwatch.start();
        while (true) {
            Throwable exception;
            ++this.attemptsSoFar;
            try {
                V value = this.body.run();
                if (this.attemptsSoFar > 1) {
                    log.info(this + ": retry successful");
                }
                return value;
            }
            catch (IOException e) {
                exception = e;
            }
            catch (ApiProxy.ApiProxyException e) {
                exception = e;
            }
            long sleepDurationMillis = (long)(Math.random() * Math.min(10000.0, Math.pow(2.0, this.attemptsSoFar - 1) * 10.0));
            log.warning(this + ": Attempt " + this.attemptsSoFar + " failed, sleeping for " + sleepDurationMillis + " ms: " + RetryHelper.messageChain(exception));
            if (this.attemptsSoFar >= 200 || this.attemptsSoFar >= 5 && this.stopwatch.elapsedMillis() >= 240000L) {
                throw new RuntimeException(this + ": Too many failures, giving up", exception);
            }
            try {
                Thread.sleep(sleepDurationMillis);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(this + ": Unexpected interruption while retrying after " + exception, e2);
            }
        }
    }

    public static <V> V runWithRetries(Body<V> body) {
        return super.doRetry();
    }

    public static interface Body<V> {
        public V run() throws IOException;
    }
}

