/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.impl.util;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Entity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class SerializationUtil {
    private SerializationUtil() {
    }

    public static Object prettyBytes(final byte[] bytes, final int offset, final int length) {
        return new Object(){

            public String toString() {
                StringBuilder out = new StringBuilder("[");
                for (int i = offset; i < length; ++i) {
                    if (i != offset) {
                        out.append(" ");
                    }
                    out.append(String.format("%02x", bytes[i]));
                }
                return out + "]@" + String.format("%x", System.identityHashCode(bytes));
            }
        };
    }

    public static Object prettyBytes(byte[] bytes) {
        return SerializationUtil.prettyBytes(bytes, 0, bytes.length);
    }

    public static Object prettyBytes(final ByteBuffer buf) {
        return new Object(){

            public String toString() {
                return "" + SerializationUtil.prettyBytes(SerializationUtil.getBytes(buf));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable deserializeFromByteArray(byte[] bytes) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            Serializable serializable = (Serializable)SerializationUtil.deserializeFromStream(in);
            return serializable;
        }
        finally {
            in.close();
        }
    }

    private static InputStream newInputStream(final ByteBuffer buf) {
        return new InputStream(){

            @Override
            public int read() {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                return buf.get();
            }

            @Override
            public int read(byte[] bytes, int off, int len) {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                int toRead = Math.min(len, buf.remaining());
                buf.get(bytes, off, toRead);
                return toRead;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deserializeFromByteBufferNoHeader(ByteBuffer bytes) throws IOException {
        ObjectInputStream in = new ObjectInputStream(SerializationUtil.newInputStream(bytes)){

            @Override
            protected void readStreamHeader() throws IOException {
            }
        };
        try {
            T value = SerializationUtil.deserializeFromStream(in);
            if (in.read() != -1) {
                throw new IOException("Trailing bytes in " + bytes + " after reading " + value);
            }
            T t = value;
            return t;
        }
        finally {
            in.close();
        }
    }

    public static <T> T deserializeFromByteArrayNoHeader(byte[] bytes) throws IOException {
        return SerializationUtil.deserializeFromByteBufferNoHeader(ByteBuffer.wrap(bytes));
    }

    public static <T> T deserializeFromStream(ObjectInputStream in) throws IOException {
        try {
            Object obj = in.readObject();
            return (T)obj;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Deserialization error", e);
        }
    }

    public static Serializable deserializeFromDatastoreProperty(Entity entity, String propertyName) throws IOException {
        return SerializationUtil.deserializeFromByteArray(((Blob)entity.getProperty(propertyName)).getBytes());
    }

    public static Serializable deserializeFromDatastorePropertyUnchecked(Entity entity, String propertyName) {
        try {
            return SerializationUtil.deserializeFromDatastoreProperty(entity, propertyName);
        }
        catch (IOException e) {
            throw new RuntimeException("Deserialization error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeToByteArray(Serializable o) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bytes);
            try {
                out.writeObject(o);
            }
            finally {
                out.close();
            }
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't serialize object: " + o, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeToByteArrayNoHeader(Serializable o) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bytes){

                @Override
                protected void writeStreamHeader() throws IOException {
                }
            };
            try {
                out.writeObject(o);
            }
            finally {
                out.close();
            }
            byte[] buf = bytes.toByteArray();
            return buf;
        }
        catch (IOException e) {
            throw new RuntimeException("Can't serialize object: " + o, e);
        }
    }

    public static byte[] getBytes(ByteBuffer in) {
        if (in.hasArray() && in.position() == 0 && in.arrayOffset() == 0 && in.array().length == in.limit()) {
            return in.array();
        }
        byte[] buf = new byte[in.remaining()];
        in.get(buf);
        return buf;
    }
}

