/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.inputs;

import com.google.appengine.api.blobstore.BlobInfoFactory;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.tools.mapreduce.Input;
import com.google.appengine.tools.mapreduce.InputReader;
import com.google.appengine.tools.mapreduce.inputs.BlobstoreInputReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BlobstoreInput
extends Input<byte[]> {
    private static final long serialVersionUID = 2235444204028285444L;
    private final String blobKey;
    private final byte separator;
    private final int shardCount;

    public BlobstoreInput(String blobKey, byte separator, int shardCount) {
        this.blobKey = blobKey;
        this.separator = separator;
        this.shardCount = shardCount;
    }

    @Override
    public List<? extends InputReader<byte[]>> createReaders() {
        long blobSize = new BlobInfoFactory().loadBlobInfo(new BlobKey(this.blobKey)).getSize();
        return this.split(this.blobKey, blobSize, this.shardCount);
    }

    private List<? extends InputReader<byte[]>> split(String blobKey, long blobSize, int shardCount) {
        try {
            Preconditions.checkNotNull(blobKey);
            Preconditions.checkArgument(shardCount > 0);
            Preconditions.checkArgument(blobSize >= 0L);
            long splitLength = blobSize / (long)shardCount;
            if (splitLength == 0L) {
                splitLength = blobSize;
                shardCount = 1;
            }
            ArrayList<BlobstoreInputReader> result = new ArrayList<BlobstoreInputReader>();
            long startOffset = 0L;
            for (int i = 1; i < shardCount; ++i) {
                long endOffset = (long)i * splitLength;
                result.add(new BlobstoreInputReader(blobKey, startOffset, endOffset, this.separator));
                startOffset = endOffset;
            }
            result.add(new BlobstoreInputReader(blobKey, startOffset, blobSize, this.separator));
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

