/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.inputs;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreInputStream;
import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.labs.repackaged.com.google.common.io.CountingInputStream;
import com.google.appengine.tools.mapreduce.InputReader;
import com.google.appengine.tools.mapreduce.inputs.InputStreamIterator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

class BlobstoreInputReader
extends InputReader<byte[]> {
    private static final long serialVersionUID = -1869136825803030034L;
    private static final int DEFAULT_BUFFER_SIZE = 10000;
    long startOffset;
    long endOffset;
    private String blobKey;
    private byte terminator;
    private long offset = 0L;
    private transient CountingInputStream input;
    private transient Iterator<InputStreamIterator.OffsetRecordPair> recordIterator;

    BlobstoreInputReader(String blobKey, long startOffset, long endOffset, byte terminator) throws IOException {
        this.blobKey = blobKey;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.terminator = terminator;
    }

    private void checkInitialized() {
        Preconditions.checkState(this.recordIterator != null, "%s: Not initialized", this);
    }

    @Override
    public byte[] next() {
        this.checkInitialized();
        if (!this.recordIterator.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.recordIterator.next().getRecord();
    }

    @Override
    public Double getProgress() {
        this.checkInitialized();
        if (this.endOffset == this.startOffset) {
            return 1.0;
        }
        double currentOffset = this.offset + this.input.getCount();
        return currentOffset / (double)(this.endOffset - this.startOffset);
    }

    @Override
    public void beginSlice() throws IOException {
        Preconditions.checkState(this.recordIterator == null, "%s: Already initialized: %s", this, this.recordIterator);
        this.input = new CountingInputStream(new BufferedInputStream((InputStream)new BlobstoreInputStream(new BlobKey(this.blobKey), this.startOffset + this.offset), 10000));
        this.recordIterator = new InputStreamIterator(this.input, this.endOffset - this.startOffset - this.offset, this.startOffset != 0L && this.offset == 0L, this.terminator);
    }

    @Override
    public void endSlice() throws IOException {
        this.checkInitialized();
        this.offset += this.input.getCount();
        this.input.close();
        this.input = null;
        this.recordIterator = null;
    }
}

