/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.inputs;

import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.labs.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.tools.mapreduce.Input;
import com.google.appengine.tools.mapreduce.InputReader;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;

public class ConsecutiveLongInput
extends Input<Long> {
    private static final long serialVersionUID = 722495043491410651L;
    private final int shardCount;
    private final long start;
    private final long limit;

    public ConsecutiveLongInput(long start, long limit, int shardCount) {
        Preconditions.checkArgument(shardCount > 0, "shardCount not positive: %s", shardCount);
        Preconditions.checkArgument(start <= limit, "start %s exceeds limit %s", start, limit);
        this.shardCount = shardCount;
        this.start = start;
        this.limit = limit;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.shardCount + ", " + this.start + ", " + this.limit + ")";
    }

    @Override
    public List<? extends InputReader<Long>> createReaders() throws IOException {
        ImmutableList.Builder b = ImmutableList.builder();
        long valuesTotal = Math.max(0L, this.limit - this.start);
        long valuesPerShard = valuesTotal / (long)this.shardCount;
        long remainder = valuesTotal % (long)this.shardCount;
        long nextStart = this.start;
        for (int i = 0; i < this.shardCount; ++i) {
            long thisLimit = nextStart + valuesPerShard + (long)((long)i < remainder ? 1 : 0);
            b.add(new Reader(nextStart, thisLimit));
            nextStart = thisLimit;
        }
        Preconditions.checkState(nextStart == this.limit, "%s != %s", nextStart, this.limit);
        return b.build();
    }

    private static class Reader
    extends InputReader<Long> {
        private static final long serialVersionUID = 796981411158026526L;
        private final long start;
        private final long limit;
        private long next;

        private Reader(long start, long limit) {
            this.start = start;
            this.limit = limit;
            this.next = start;
        }

        @Override
        public Double getProgress() {
            return this.limit <= this.start ? 1.0 : (double)(this.next - this.start) / (double)(this.limit - this.start);
        }

        @Override
        public Long next() {
            if (this.next >= this.limit) {
                throw new NoSuchElementException();
            }
            return this.next++;
        }
    }
}

