/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.inputs;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.tools.mapreduce.Input;
import com.google.appengine.tools.mapreduce.InputReader;
import com.google.appengine.tools.mapreduce.inputs.DatastoreInputReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class DatastoreInput
extends Input<Entity> {
    private static final Logger logger = Logger.getLogger(DatastoreInput.class.getName());
    private static final String SCATTER_RESERVED_PROPERTY = "__scatter__";
    private static final int SCATTER_OVERSAMPLE_FACTOR = 32;
    private static final long serialVersionUID = -3939543473076385308L;
    private String entityKind;
    private int shardCount;

    public DatastoreInput() {
    }

    public DatastoreInput(String entityKind, int shardCount) {
        this.entityKind = entityKind;
        this.shardCount = shardCount;
    }

    @Override
    public List<? extends InputReader<Entity>> createReaders() {
        Preconditions.checkNotNull(this.entityKind);
        logger.info("Getting input splits for: " + this.entityKind);
        DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();
        Key startKey = DatastoreInput.getStartKey(this.entityKind, datastoreService);
        if (startKey == null) {
            logger.info("No data");
            return Collections.emptyList();
        }
        Key lastKey = startKey;
        ArrayList<DatastoreInputReader> result = new ArrayList<DatastoreInputReader>();
        for (Key currentKey : this.chooseSplitPoints(datastoreService)) {
            DatastoreInputReader source = new DatastoreInputReader(this.entityKind, lastKey, currentKey);
            result.add(source);
            logger.info(String.format("Added DatastoreInputSplit %s %s %s", source, lastKey, currentKey));
            lastKey = currentKey;
        }
        result.add(new DatastoreInputReader(this.entityKind, lastKey, null));
        return result;
    }

    public String getEntityKind() {
        return this.entityKind;
    }

    public void setEntityKind(String entityKind) {
        this.entityKind = entityKind;
    }

    public int getShardCount() {
        return this.shardCount;
    }

    public void setShardCount(int shardCount) {
        this.shardCount = shardCount;
    }

    private Iterable<Key> chooseSplitPoints(DatastoreService datastoreService) {
        int desiredScatterResultCount = this.shardCount * 32;
        Query scatter = new Query(this.entityKind).addSort(SCATTER_RESERVED_PROPERTY).setKeysOnly();
        List scatterList = datastoreService.prepare(scatter).asList(FetchOptions.Builder.withLimit((int)desiredScatterResultCount));
        Collections.sort(scatterList, new Comparator<Entity>(){

            @Override
            public int compare(Entity o1, Entity o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        ArrayList<Key> splitKeys = new ArrayList<Key>(this.shardCount - 1);
        int usedOversampleFactor = Math.max(1, scatterList.size() / this.shardCount);
        logger.info("Requested " + desiredScatterResultCount + " scatter entities. Got " + scatterList.size() + " so using oversample factor " + usedOversampleFactor);
        for (int i = 1; i < this.shardCount && i * usedOversampleFactor < scatterList.size(); ++i) {
            splitKeys.add(((Entity)scatterList.get(i * usedOversampleFactor)).getKey());
        }
        return splitKeys;
    }

    private static Key getStartKey(String entityKind, DatastoreService datastoreService) {
        Query ascending = new Query(entityKind).addSort("__key__").setKeysOnly();
        Iterator ascendingIt = datastoreService.prepare(ascending).asIterator(FetchOptions.Builder.withLimit((int)1));
        if (!ascendingIt.hasNext()) {
            return null;
        }
        return ((Entity)ascendingIt.next()).getKey();
    }
}

