/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.inputs;

import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.tools.mapreduce.InputReader;
import java.util.NoSuchElementException;

class DatastoreInputReader
extends InputReader<Entity> {
    private static final long serialVersionUID = -2164845668646485549L;
    private final String entityKind;
    final Key startKey;
    final Key endKey;
    private final int batchSize = 50;
    private Key currentKey;
    private transient QueryResultIterator<Entity> iterator;

    DatastoreInputReader(String entityKind, Key startKey, Key endKey) {
        this.entityKind = entityKind;
        this.startKey = startKey;
        this.endKey = endKey;
    }

    @Override
    public Entity next() {
        Preconditions.checkState(this.iterator != null, "%s: Not initialized: %s", this, this.iterator);
        if (!this.iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Entity entity = (Entity)this.iterator.next();
        this.currentKey = entity.getKey();
        return entity;
    }

    @Override
    public Double getProgress() {
        return null;
    }

    @Override
    public void beginSlice() {
        Preconditions.checkState(this.iterator == null, "%s: Already initialized: %s", this, this.iterator);
        Query q = new Query(this.entityKind);
        if (this.currentKey == null) {
            if (this.startKey != null) {
                q.addFilter("__key__", Query.FilterOperator.GREATER_THAN_OR_EQUAL, (Object)this.startKey);
            }
        } else {
            q.addFilter("__key__", Query.FilterOperator.GREATER_THAN, (Object)this.currentKey);
        }
        if (this.endKey != null) {
            q.addFilter("__key__", Query.FilterOperator.LESS_THAN, (Object)this.endKey);
        }
        q.addSort("__key__");
        this.iterator = DatastoreServiceFactory.getDatastoreService().prepare(q).asQueryResultIterator(FetchOptions.Builder.withChunkSize((int)50));
    }
}

