/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.mapreduce.inputs;

import com.google.appengine.labs.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.labs.repackaged.com.google.common.io.ByteStreams;
import com.google.appengine.labs.repackaged.com.google.common.io.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class InputStreamIterator
implements Iterator<OffsetRecordPair> {
    private static final Logger log = Logger.getLogger(InputStreamIterator.class.getName());
    private static final int READ_LIMIT = 0x100000;
    private final CountingInputStream input;
    private final long length;
    private final boolean skipFirstTerminator;
    private final byte terminator;
    private OffsetRecordPair currentValue;

    InputStreamIterator(CountingInputStream input, long length, boolean skipFirstTerminator, byte terminator) {
        this.input = Preconditions.checkNotNull(input);
        this.length = length;
        this.skipFirstTerminator = skipFirstTerminator;
        this.terminator = terminator;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.input.getCount() == 0L && this.skipFirstTerminator && this.skipUntilNextRecord(this.input) != SkipRecordResult.TERMINATOR) {
                return false;
            }
            if (this.input.getCount() - 1L >= this.length) {
                return false;
            }
            long recordStart = this.input.getCount();
            this.input.mark(0x100000);
            SkipRecordResult skipValue = this.skipUntilNextRecord(this.input);
            if (skipValue == SkipRecordResult.AT_EOF) {
                return false;
            }
            long recordEnd = this.input.getCount();
            this.input.reset();
            int byteValueLen = (int)(recordEnd - recordStart);
            if (skipValue == SkipRecordResult.TERMINATOR) {
                --byteValueLen;
            }
            byte[] byteValue = new byte[byteValueLen];
            ByteStreams.readFully((InputStream)this.input, (byte[])byteValue);
            if (skipValue == SkipRecordResult.TERMINATOR) {
                Preconditions.checkState(this.input.skip(1L) == 1L);
            }
            this.currentValue = new OffsetRecordPair(recordStart, byteValue);
            return true;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to read next record", e);
            return false;
        }
    }

    @Override
    public OffsetRecordPair next() {
        return this.currentValue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private SkipRecordResult skipUntilNextRecord(InputStream stream) throws IOException {
        int value;
        boolean readCharSinceTerminator = false;
        do {
            if ((value = stream.read()) == -1) {
                return readCharSinceTerminator ? SkipRecordResult.EOF_AFTER_RECORD : SkipRecordResult.AT_EOF;
            }
            readCharSinceTerminator = true;
        } while (value != (this.terminator & 0xFF));
        return SkipRecordResult.TERMINATOR;
    }

    public static class OffsetRecordPair {
        private final long offset;
        private final byte[] record;

        public OffsetRecordPair(long offset, byte[] record) {
            this.offset = offset;
            this.record = record;
        }

        public long getOffset() {
            return this.offset;
        }

        public byte[] getRecord() {
            return this.record;
        }

        public boolean equals(Object rhs) {
            if (!(rhs instanceof OffsetRecordPair)) {
                return false;
            }
            OffsetRecordPair rhsPair = (OffsetRecordPair)rhs;
            return this.offset == rhsPair.getOffset() && Arrays.equals(this.record, rhsPair.getRecord());
        }

        public int hashCode() {
            return new Long(this.offset).hashCode() ^ Arrays.hashCode(this.record);
        }
    }

    private static enum SkipRecordResult {
        AT_EOF,
        EOF_AFTER_RECORD,
        TERMINATOR;

    }
}

